/*
    Library for the 4DGL uLCD-144-G2 LCD Display that Makes and 
    Contols Eyes. 
    
    TODO: Allow user to define eye color, size, etc.
          Allow user to adjust serial baudrate, etc.
          Fix memory leak? LCD stops working and displays
          some weird stuff after running for awhile, this 
          needs fixin'
*/

#ifndef EYES_H
#define EYES_H

#include "mbed.h"
#include "uLCD_4DGL.h"
#include "Timeout.h"

class Eyes{
    public: 
    enum EXPRESSION{NORMAL, SUPRISED, SCARED, ANGRY}; 
    enum DIRECTION{U = 270, D = 90, L = 0, R = 180, C, 
                   UL= 315, UR= 225,DL= 45, DR = 135};
    enum GESTURE{BLINK, CLOSE, SHAKE};
    typedef struct{int x; int y;}Coord_t;
    
    /*
        Constructor for Eyes Objects
    */
    Eyes(PinName tx, PinName rx, PinName reset);
    
    /* 
        Change the active direction eyes look. 
        @param direction     The direction to look
    */
    void look(DIRECTION direction);
    
    /*
        Change the distance and direction the eyes look.
        @param theta    The angle to look in degrees
        @param dist     The normalized distance to look in given theta, i.e
                        0 keeps eyes centered and 1 looks fully in given theta
                        in between values give make eyes look more or less in 
                        theta.
    */
    void look_there(int theta, float dist);
    
    /*
        Display a gesture. 
        
        BLINK is random ~100 to ~400ms. For user defined blink duration
        call CLOSE, then draw() some user defined time later.
        
        NOTE: Some gestures use a timer interrupt to make a 
        callback to complete a gesture, such as BLINK. Although this should
        be ok, as the draw method is called on the interrupt and simply
        redraws eyes with current setting, the user should be aware if they
        are getting some weird side effects.
        
        @param gesture  The gesture to display
    */
    void gesture(GESTURE gesture);
    
    /* 
        Draw eyes conveying given expression (keeps current look direction)
        @param expression    The expression of the eyes
    */  
    void express(EXPRESSION expression);
    
    /*
        Draw Eyes. Uses the currently active direction and expression.
        Call this after calling express() and or look() methods, this
        allows greater flexibility to user and reduces calls to draw
        as user can set both expression and direction and make a single
        call to draw.
    */
    void draw();  
    
    private:
    uLCD_4DGL lcd; // serial tx, serial rx, reset pin;
    Timeout callback_timer;
    
    EXPRESSION active_expression;
    DIRECTION  active_direction;
    /*TODO: Make these user defined*/
    int eye_radius;
    int iris_radius;
    int pupil_radius;
    /******************************/
    Coord_t right_eye_center;  
    Coord_t left_eye_center;
    Coord_t eye_direction_offset; // Updated by look direction
                                  // Used to apply an offset to 
                                  // iris and pupils to make
                                  // eyes look in a direction
};

#endif