#include "Eyes.h"

Eyes::Eyes(PinName tx, PinName rx, PinName reset): lcd(tx, rx, reset){
    right_eye_center.x = 37; right_eye_center.y = 42;
    left_eye_center.x = 89; left_eye_center.y = 42;
    active_expression = NORMAL;
    active_direction   = C;
    eye_radius   = 20;
    iris_radius  = 10;
    pupil_radius = 5;
    lcd.baudrate(3000000);              // Jack up baud rate for smooth operator eyes
    lcd.cls();                          // Master clear screen
    draw();                             // Initialize the eyes on screen
}

void Eyes::look(DIRECTION direction){
    if(direction == C){
        eye_direction_offset.x = 0; 
        eye_direction_offset.y = 0;
    }
    else{
        int radius(eye_radius - iris_radius);
        eye_direction_offset.x = (int)(radius*cos(direction*3.14/180.0)); 
        eye_direction_offset.y = (int)(radius*sin(direction*3.14/180.0));
    }
}

void Eyes::look_there(int theta, float dist){
    theta = theta % 361;       // Clamp theta to 0 to 360 degrees
    if(dist > 1.0) dist = 1.0;  // Clamp dist to 1.0 max
    if(dist < 0.0) dist = 0.0;  // Clamp dist to 0.0 min
    
    int radius(eye_radius - iris_radius);
    eye_direction_offset.x = (int)(dist*radius*cos(theta*3.14/180.0)); 
    eye_direction_offset.y = (int)(dist*radius*sin(theta*3.14/180.0));
}

void Eyes::express(EXPRESSION expression){}

void Eyes::gesture(GESTURE gesture){
    switch(gesture){
        // "Clear" Screen/ Black out Eyes
        case BLINK:
            lcd.filled_circle(right_eye_center.x, right_eye_center.y,
                              eye_radius, BLACK);
            lcd.filled_circle(left_eye_center.x, left_eye_center.y,
                              eye_radius, BLACK);    
            // Manually Draw lines that look like closed eye lids
            lcd.line(right_eye_center.x - eye_radius, right_eye_center.y,
                     right_eye_center.x + eye_radius, right_eye_center.y,
                     LGREY);
            lcd.line(left_eye_center.x - eye_radius, left_eye_center.y,
                     left_eye_center.x + eye_radius, left_eye_center.y,
                     LGREY);
            callback_timer.attach(this, &Eyes::draw, (rand()%301)*0.001 + 0.075); // Between 100ish and 400ish (serial overhead makes it ish)
            break;
        
        case CLOSE:
            lcd.filled_circle(right_eye_center.x, right_eye_center.y,
                              eye_radius, BLACK);
            lcd.filled_circle(left_eye_center.x, left_eye_center.y,
                              eye_radius, BLACK);
            // Manually Draw lines that look like closed eye lids
            lcd.line(right_eye_center.x - eye_radius, right_eye_center.y,
                     right_eye_center.x + eye_radius, right_eye_center.y,
                     LGREY);
            lcd.line(left_eye_center.x - eye_radius, left_eye_center.y,
                     left_eye_center.x + eye_radius, left_eye_center.y,
                     LGREY);
            break;
            
        case SHAKE:
            break; 
    }
}

void Eyes::draw(){
    //Draw over last eye in black to "erase" before drawing new eye
    lcd.filled_circle(right_eye_center.x,
                      right_eye_center.y,
                      eye_radius, BLACK);
    
    lcd.filled_circle(left_eye_center.x,
                      left_eye_center.y,
                      eye_radius, BLACK);
    
    // Draw right eye
    lcd.filled_circle(right_eye_center.x,
                      right_eye_center.y,
                      eye_radius, WHITE);
    lcd.filled_circle(right_eye_center.x + eye_direction_offset.x,
                      right_eye_center.y + eye_direction_offset.y,
                      iris_radius, BLUE);
    lcd.filled_circle(right_eye_center.x + eye_direction_offset.x,
                      right_eye_center.y + eye_direction_offset.y,
                      pupil_radius, BLACK);
                      
    // Draw left eye
    lcd.filled_circle(left_eye_center.x,
                      left_eye_center.y,
                      eye_radius, WHITE);
    lcd.filled_circle(left_eye_center.x + eye_direction_offset.x,
                      left_eye_center.y + eye_direction_offset.y,
                      iris_radius, BLUE);
    lcd.filled_circle(left_eye_center.x + eye_direction_offset.x,
                      left_eye_center.y + eye_direction_offset.y,
                      pupil_radius, BLACK);
}