/*
    Eyes Class produces an LCD Object with Eyes that can look around, blink,
    convey expressions, etc. 
    
    TODO: Replace "wait()" with Thread::wait() so that this isn't eating
          up processor time!. Maybe could use a Ticker or Timer interrupt
          but we don't want to call Eye methods until wait is complete...
          so that probably isn't a good idea... Thread::wait() is probably 
          best for an end application.
          
          OR add close_eyes to gesture() method and leave it to user to 
          create blink gestures and other gestures that require waits...
          this can be mentioned in the header and documentation with 
          solutions the user can use.
*/

#include "mbed.h"
#include "Eyes.h"


Eyes eyes(p28, p27, p30); // serial tx, serial rx, reset pin;
int main() {
    while(1){
        int dir = rand()%10;
        Eyes::DIRECTION direction;
        switch(dir){
            case 0:
                direction = Eyes::U;
                break;
            case 1:
                direction = Eyes::D;
                break;
            case 2:
                direction = Eyes::L;
                break;
            case 3:
                direction = Eyes::R;
                break;
            case 4:
                direction = Eyes::C;
                break;
            case 5:
                direction = Eyes::UL;
                break;
            case 6:
                direction = Eyes::UR;
                break;
            case 7:
                direction = Eyes::DL;
                break;
            case 8:
                direction = Eyes::DR;
                break;        
        }
        eyes.look(direction);
        eyes.draw();             // Call this after calling look() or express()
        wait((rand()%10 + 1)*0.40);
        eyes.gesture(Eyes::BLINK);
        wait((rand()%10 + 1)*0.25);
        if(rand()%2) eyes.gesture(Eyes::CLOSE);
        wait((rand()%10 + 1)*0.25);
    }
}
