/*
    Bryce Williams 
    10/19/2015
    
    Basic Demo of the TI DRV2605L Haptics Driver Breakout. 
    This code uses the MPR121 Library and modified version 
    of Dr. Jim Hamblen's Hello World Example for the MPR121
    for Capacitive Touch Keypad for user input. 
    
    The user and touch keys 3,7,11,2,6,10, 1,5,9,and 0. 
    Each Key will toggle through about 10 effects each,
    (key 11 toggles between 12 or 13 of the effects). 
    Effects are the ROM Library Haptics effects internal to 
    the  DRV2605L Haptics Driver. 
*/

#include "mbed.h"
#include "DRV2605.h"
#include "mpr121.h"

DRV2605 haptics(p9, p10);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
// Setup the i2c bus on pins 28 and 27
I2C i2c(p28, p27);
// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p26);

// Setup the Mpr121 Cap Touch Driver:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

void fallInterrupt() {
    int key_code=0;
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    // LED demo mod by J. Hamblen
    printf("MPR value: %x \r\n", value);
    i=0;
    // puts key number out to LEDs for demo
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
        }
    led4=key_code & 0x01;
    led3=(key_code>>1) & 0x01;
    led2=(key_code>>2) & 0x01;
    led1=(key_code>>3) & 0x01;

    // Evaluate Keypad from Left-to-Right Top-to-Bottom like reading
    // Each Key sequences through decimal indexes ending with 
    // corresponding positions... i.e. 
    // Key 3 (value = 800) sequences 3, 13, 23, ... 123
    // Key 5 (value = 40) sequences 5, 15, 25,... 115
    // Key 11(value = 10) and 12 (value = 100) are free for custom 
    // implementation
    switch(value){
        static int e1 = 1, e2 = 2, e3 = 3, e4 = 4, e5 = 5, e6 = 6,
                   e7 = 7, e8 = 8, e9 = 9, e10 = 10;
        case 0x8:
            printf("Playing %i\n", e1);
            haptics.play_waveform(e1);
            e1+=10; 
            if(e1 > 121) e1 = 1;
            break;
        case 0x80:
            printf("Playing %i\n", e2);
            haptics.play_waveform(e2);
            e2+=10; 
            if(e2 > 122) e2 = 2;
            break;
        case 0x800:
            printf("Playing %i\n", e3);
            haptics.play_waveform(e3);
            e3+=10; 
            if(e3 > 123) e3 = 3;
            break;
        case 0x4:
            printf("Playing %i\n", e4);
            haptics.play_waveform(e4);
            e4+=10; 
            if(e4 > 114) e4 = 4;
            break;
        case 0x40:
            printf("Playing %i\n", e5);
            haptics.play_waveform(e5);
            e5+=10; 
            if(e5 > 115) e5 = 5;
            break;
        case 0x400:
            printf("Playing %i\n", e6);
            haptics.play_waveform(e6);
            e6+=10; 
            if(e6 > 116) e6 = 6;
            break;
        case 0x2:
            printf("Playing %i\n", e7);
            haptics.play_waveform(e7);
            e7+=10; 
            if(e7 > 117) e7 = 7;
            break;
        case 0x20:
            printf("Playing %i\n", e8);
            haptics.play_waveform(e8);
            e8+=10; 
            if(e8 > 118) e8 = 8;
            break;
        case 0x200:
            printf("Playing %i\n", e9);
            haptics.play_waveform(e9);
            e9+=10; 
            if(e9 > 119) e9 = 9;
            break;
        case 0x1:
            printf("Playing %i\n", e10);
            haptics.play_waveform(e10);
            e10+=10; 
            if(e10 > 120) e10 = 10;
            break;
        case 0x10:
            break;
        case 0x100:
            break;
    }
}

int main() {
    // Set up Interrupts for MPR121 Cap Touch Driver/ Keypad
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    
    // Daignostics Routine
    printf("Diagnostics Result: %X\n", haptics.diagnostics());
        
    // Initialization Procedure as outlined in Section 9.3 of Device Datasheet
    printf("Calibration Result: %X\n",haptics.init(3.3));
    
    // Daignostics Routine
    printf("Diagnostics Result: %X\n", haptics.diagnostics());
    
    // Play sequence of library waveforms as outlined in Section 9.3.2.1 of Device Datasheet
    haptics.load_waveform_sequence(123,21,43,18,94,48,112,36);
    haptics.play();
    while(haptics.i2cReadByte(GO));         // Wait for playback to complete
    
    wait(2);
    
    haptics.load_waveform_sequence(55,65);
    haptics.play();
    while(haptics.i2cReadByte(GO));         // Wait for playback to complete
    
    wait(2);
    
    // Play a waveform corresponding to touch-keypad press
    while(1);
}
