/*
 *
 *    BLE Nano2 : USB Serial Communication
 *
 *    http://jellyware.jp/kurage/
 * 
 */
 
 
//------------------------------------------------------------
//Include Header Files
//------------------------------------------------------------ 
#include "mbed.h"
 
 
//------------------------------------------------------------
//Definition
//------------------------------------------------------------ 
#define ANALOG_IN_PIN1 P0_5
#define TICKER_TIME 1000                    //1000[us] = 1[ms]

//HeartRate
int timer_num = 0;
int threshold_v = 650;
int threshold_t = 300;


//======================================================================
//onTimeout
//======================================================================
void m_status_check_handle(void)
{   
    timer_num ++;
}


//------------------------------------------------------------
//Object generation
//------------------------------------------------------------ 
AnalogIn ANALOG1(ANALOG_IN_PIN1);
Serial pc(P0_29, P0_30);

int main(void)
{
    pc.baud(9600);
    char str[10];

    //Timer Setting [us]
    Ticker ticker;
    ticker.attach_us(m_status_check_handle, TICKER_TIME);
    
    int timer_ms;     
    
    while(1)
    {
        float s = ANALOG1;
        uint16_t value = s * 1024;
                        
        //---------------------------------------------------------------------------------------------       
        //Detect HeartRate Peak
        //--------------------------------------------------------------------------------------------- 
        timer_ms = TICKER_TIME/1000 * timer_num;
        if(value >= threshold_v && timer_ms > threshold_t)
        {    
            //clear timer_num
            timer_num = 0;              
              
            sprintf(str, "%d\r\n", timer_ms);
            pc.printf(str);
        }       
    }
}