#include "mbed.h"
#define MEDIDA 10 //Declaracion de una constante para decir el tamaño del arreglo

AnalogIn Volt_Out(A5);
AnalogIn Volt_Ohmetro(A4);
DigitalOut Led_Prueba(LED1);
Serial pc(USBTX, USBRX);
Timer reloj;//Declaracion de varibales, timer y puerto serial
DigitalIn boton_Volt(A3);
DigitalIn boton_Resitencia(A2);

float Volt_In, Tiempo_Led, Tiempo,Promedio, Vout_val,Ohms;
float Voltajes_por_seg[]= {0};
float Ohms_por_seg[] = {0}; //Inicializacion de un arreglo con 0 en cada lugar

float promedio (float arreglo[MEDIDA])          //Funcion para sacar el promedio dentro de los valores de un arreglo mediante un contador
{
    float acumulado = 0;
    for (int count = 0; count < MEDIDA; count++) { //Aumento de lugar en el Arreglo
        acumulado += Voltajes_por_seg[count]; //Suma del valor en el lugar count del arreglo
    }
    return acumulado/MEDIDA;                  //Regresa el promedio como un valor float
}

int main()
{
    reloj.start();                  //Comienzo del timer
    Tiempo_Led = reloj.read();      //Inicializar una variable que sera la lectura del timer
    while (Tiempo_Led <= 1.5) {     //Al oprimir el boton reset prendera un led rojo durante 1.5segundos como medida de seguridad para saber que no quemamos nuestra tarjeta
        Tiempo_Led = reloj.read();
        Led_Prueba = 0;
    }
    Led_Prueba = 1;
    reloj.reset();                  //El timer se resetea para tomar las medidas para el voltaje
    while(1) {
        if(boton_Volt==1 && boton_Resitencia==0) {
            Vout_val = Volt_Out*5;           //Una variable que tendra el valor del voltaje de salida y lo, se multiplica por 5 ya que los puertos analogicos dan lecturas de 0 a 1 y con 5 volts fue alimentada esta practica
            Tiempo = reloj.read();
            if(Tiempo > 0 && Tiempo < 0.5 ) { //Cada 0.5 segundos tomara las mediciones
                for (int indice = 0; indice < MEDIDA; indice++) { //Ciclo que introduce cada valor del voltaje a cada espacio en el arreglo
                    Voltajes_por_seg[indice]= Voltajes_por_seg[indice+1]; //Se suma al indice un 1 para el lugar siguiente en el arreglo
                    Volt_In = ((Volt_Out*10330)/10000)*5; //Al voltaje de salida se multiplica por la suma de R1+R2 y se divide entre R1, se multiplica de nuevo por 5 por ser el voltaje con que alimentamos
                    Voltajes_por_seg[MEDIDA-1]= Volt_In; //Elmininamos el primer valor y lo sustituimos por el siguiente
                    reloj.reset(); //El timer se resetea para hacer de nuevo mediciones
                }
                Promedio=promedio(Voltajes_por_seg); //Uso del promedio para saber el voltaje de entrada
                pc.printf("Voltaje en promedio es %f \n",Promedio*28/5); //Saber que voltaje de entrada tengo a 28 volts de alimentacion¡
            }

        } else if(boton_Volt==0 && boton_Resitencia==1) {
            Tiempo = reloj.read();
            if(Tiempo > 0 && Tiempo < 0.5 ) { //Cada 0.5 segundos tomara las mediciones
                for (int indice = 0; indice < MEDIDA; indice++) {
                    Ohms_por_seg[indice]= Ohms_por_seg[indice+1];
                    Ohms = 1/(1/(Volt_Ohmetro*3.3/.005-560)-1/100);//Resistencia, conociendo Vo //Ciclo que introduce cada valor del voltaje a cada espacio en el arreglo
                    Ohms_por_seg[MEDIDA-1]= Ohms; //Elmininamos el primer valor y lo sustituimos por el siguiente
                    reloj.reset(); //El timer se resetea para hacer de nuevo mediciones
                }
                Promedio=promedio(Ohms_por_seg);
                pc.printf("Resistencia 2 en promedio es %f \n",Promedio*3.3);
            }
        }
    }
}
