/*Este es el código de un juego donde 2 jugadores tienen el objetivo de picar un botón mientras un led se encuentre encendido.
El led se encuentra encendido durante un tiempo generado aleatoriamente por eso el uso de una función rand().
Se usan estructuras para el puntaje de ambos jugadores, un timer para leer si uno de los dos botones fue presionado,el led integrado de la freedom como indicador.
Al presionar un botón se realiza una interrupción del código y se apaga el led, eso genera que el puntaje del jugador aumente y se imprima en un display de 7 segmentos.
Si se desea reiniciar el juego se puede oprimir un tercer botón de reseteo o se reinicia cuando cualquier jugador llegue al puntaje de 5.*/

#include "mbed.h"

struct players {
    int score;
} player1, player2;

DigitalOut myled(LED3);
BusOut Display1 (PTC8, PTA5, PTA12, PTD4, PTA2, PTA1); //G,f,E,...
BusOut Display2 (PTC9, PTA13, PTD5, PTD0, PTD2, PTD3, PTD1);//G,f,E,.
InterruptIn Bplayer1 (PTC2);
InterruptIn Bplayer2 (PTC3);
DigitalIn Boton3 (PTC4);
int numero_rand;
int juegos = 0;
Timer tiempo;

void Player1Score()
{
    player1.score = player1.score+1;
    tiempo.reset();
}
void Player2Score()
{
    player2.score = player2.score+1;
    tiempo.reset();
}
int CeroAlNueve(int paso)
{
    int Valor = 0;
    switch (paso) {
        case 0:
            Valor = 63;
            break;
        case 1:
            Valor = 6;
            break;
        case 2:
            Valor = 91;
            break;
        case 3:
            Valor = 79;
            break;
        case 4:
            Valor = 102;
            break;
        case 5:
            Valor = 109;
            break;
        case 6:
            Valor = 125;
            break;
        case 7:
            Valor = 7;
            break;
        case 8:
            Valor = 127;
            break;
        case 9:
            Valor = 103;
            break;
    }
    return Valor;
}

void PrintDisplay(int puntos1, int puntos2)
{
    Display1 = CeroAlNueve(puntos1);
    Display2 = CeroAlNueve(puntos2);
}

int main ()
{
    tiempo.start();
    srand (time(NULL));
    numero_rand =  rand() % 10 + 1;
    myled=1;
    Bplayer1.rise(&Player1Score);
    Bplayer2.rise(&Player2Score);
    while(1) {

        player1.score= 0;
        player2.score = 0;
        PrintDisplay(player1.score, player2.score);
        while(tiempo.read() >= numero_rand) {
            myled=0;

        }
        if(Boton3 == 1) {
            return 0;
        }
        if((player1.score || player2.score) == 5) {
            player1.score= 0;
            player2.score = 0;
        }
    }
}

