#include "mbed.h"
#define MEDIDA 10
DigitalOut myled(LED3);
//               A   B   C   D   E   F   G Mas significativo a menor
BusOut Display (D4, D5, D8, D7, D6, D3, D2);
//               A     B     C     D     E     F     G
BusOut Display2 (PTD2, PTD3, PTE1, PTE0, PTD1, PTD0, PTB0);
DigitalIn Boton (PTC2);
DigitalOut Punto_Decimal(PTD5);
DigitalOut Led_Prueba(LED1);
AnalogIn Volt_Ohmetro(PTB1);
AnalogIn Volt_In(PTB2);
Timer reloj;

Serial pc(USBTX, USBRX);

float Volt_Out, Tiempo_Led, Tiempo, Prom_Val, Vin, R1;
float Voltajes_por_seg[MEDIDA + 1];
bool Flag_Boton, Cambiar;

int CeroAlNueve(int paso)
{
    int Valor = 0;
    switch (paso) {
        case 0:
            Valor = 63;
            break;
        case 1:
            Valor = 6;
            break;
        case 2:
            Valor = 91;
            break;
        case 3:
            Valor = 79;
            break;
        case 4:
            Valor = 102;
            break;
        case 5:
            Valor = 109;
            break;
        case 6:
            Valor = 125;
            break;
        case 7:
            Valor = 7;
            break;
        case 8:
            Valor = 127;
            break;
        case 9:
            Valor = 103;
            break;
    }
    return Valor;
}

void PrintDisplay(int contador)
{
    if(Punto_Decimal=1) {
        contador = contador*10;
    } else {
        contador = contador;
    }
    int unidad, decena = 0;
    decena = contador/10;
    Display = CeroAlNueve(decena);
    unidad = contador - decena*10;
    Display2 = CeroAlNueve(unidad);
}

float promedio (float arreglo[])
{
    float acumulado = 0;
    for (int count = 0; count < MEDIDA; count++) {
        acumulado += Voltajes_por_seg[count]; //sumo los datos
    }
    return acumulado/MEDIDA; // los divido por la cantidad de numeros
}

int main()
{
    reloj.start();
    Tiempo_Led = reloj.read();
    while (Tiempo_Led <= 1.5) {
        Tiempo_Led = reloj.read();
        Led_Prueba = 0;
    }
    Led_Prueba = 1;
    reloj.reset();
    while (1) {
        Flag_Boton = 0;
        while(Flag_Boton != 1) {
            Tiempo = reloj.read();
            if(Tiempo >= 0.5) {
                Vin = (Volt_Out*3.3)*(5600/660);
                R1 = (10*Vin)/(3.3 - Vin); // R1 = (R2*Vin)/(Vout - Vin);
                Voltajes_por_seg[MEDIDA]= R1;
                reloj.reset();
                for (int indice = 0; indice <= MEDIDA; indice++) {
                    Voltajes_por_seg[indice]= Voltajes_por_seg[indice+1];
                }
            }
            if (Boton == 1) {
                while (Tiempo < 1) {
                    Tiempo = reloj.read();
                    Flag_Boton = 1;
                }
                reloj.reset();
            }
            Prom_Val = promedio(Voltajes_por_seg);
            if(Prom_Val > 10) {
                PrintDisplay(Prom_Val);
            }
        }
        Flag_Boton = 1;
        while(Flag_Boton != 0) {
            Tiempo = reloj.read();
            if(Tiempo >= 0.5) {
                Volt_Out = Volt_In*30.3;   // La resistencia número 1 es 2.2kOhm y 2 de 18Kohm
                Voltajes_por_seg[10]= Volt_Out;
                reloj.reset();
                for (int indice = 0; indice <= MEDIDA; indice++) {
                    Voltajes_por_seg[indice]= Voltajes_por_seg[indice+1];
                }
            }
            if (Boton == 1) {
                while (Tiempo < 1) {
                    Tiempo = reloj.read();
                    Flag_Boton = 0;
                }
                reloj.reset();
            }
            Prom_Val = promedio(Voltajes_por_seg);
            if(Prom_Val > 10) {
                PrintDisplay(Prom_Val);
            }

        }
    }
}