/**
 * Programme de contrôle des essuie-glace, des clignotants et des lumières de freins
 *
 * par Jasmin St-Laurent
 *
 * Acceuil des étudiants de secondaire 3 au Collège de Maisonneuve
 *
 * 18 janvier 2017
 */

// Blibliothèques de fonctions utilisés dans ce programme
#include "mbed.h"
#include "Servo.h"

// Entrées numériques commandant le système
DigitalIn Levier_Clignotant_Gauche(p5);
DigitalIn Levier_Clignotant_Droit(p6);
InterruptIn Bouton_Clignotant_Urgence(p7);
DigitalIn Levier_Essuie_Glace_Intermitent(p8);
DigitalIn Levier_Essuie_Glace_Continue(p9);
DigitalIn Pedale_Frein(p10);

// Voyant représentant les clignotants et lumières de freins
DigitalOut Clignotant_Gauche(LED1);
DigitalOut Clignotant_Droit(LED4);
DigitalOut Lumiere_Frein_1(LED2);
DigitalOut Lumiere_Frein_2(LED3);

// Servomoteur représentant les essuies-glace
Servo Essuie_Glace(p21);

// Temporisateurs servant à faire exécuter les actions périodiques
Ticker Temporisateur_Clignotant;
Ticker Temporisateur_Essuie_Glace;

// Variable servant à mémoriser l'état du clignotant d'urgence
bool Clignotant_Urgence_Actif = false;


/**
 * Fonction faisant clignoter les voyants
 *
 * Exécutée chaque quart de seconde
 */
void Tache_Clignotant(void)
{
    if (Clignotant_Urgence_Actif)
    {
        // On fait clignoter les deux lumières simultanément
        Clignotant_Gauche = Clignotant_Droit = !Clignotant_Droit;
    }
    else if (Levier_Clignotant_Gauche)
    {
        // On fait clignoter seulement la lumière de gauche
        Clignotant_Gauche = !Clignotant_Gauche;
        Clignotant_Droit = 0;
    }
    else if (Levier_Clignotant_Droit)
    {
        // On fait clignoter seulement la lumière de droite
        Clignotant_Droit = !Clignotant_Droit;
        Clignotant_Gauche = 0;
    }
    else
    {
        // On éteint les deux clignotants
        Clignotant_Gauche = 0;
        Clignotant_Droit = 0;
    }
}


/*
 * Fonction appelée l'orqu'on appui sur le bouton du clignotant d'urgence.
 *
 * Si le clignotant d'urgence est inactif, on l'active.
 * Si le clignotant d'urgence est actif, on le désactive.
 */
void Activer_Desactiver_Clignotant_Urgence(void)
{
    Clignotant_Urgence_Actif = !Clignotant_Urgence_Actif;
}


/**
 * Fonction faisant bouger les essuies-glace
 *
 * Exécutée chaque quart de seconde
 */
void Tache_Essuie_Glace(void)
{
    static enum {ATTENTE, BAS, HAUT} Direction = HAUT;
    static float Position = 0;
    static int Compteur_Attente = 0;
    
    if (Levier_Essuie_Glace_Intermitent || Levier_Essuie_Glace_Continue)
    {
        if (Direction == HAUT)
        {
            Position = Position + 0.01;
            if (Position >= 1)
            {
                Direction = BAS;
            }
        }
        else if (Direction == BAS)
        {
            Position = Position - 0.01;
            if (Position <= 0)
            {
                if (Levier_Essuie_Glace_Continue)
                {
                    Direction = HAUT;
                }
                else
                {
                    Direction = ATTENTE;
                }
            }
        }
        else    // Sinon on est en attente
        {
            Compteur_Attente = Compteur_Attente + 1;
            
            if (Compteur_Attente >= 100)
            {
                Compteur_Attente = 0;
                Direction = HAUT;
            }
        }
    }
    
    Essuie_Glace = Position;
}

/*
 * Programme principal
 */    

int main(void) 
{
    /* Initialisation - Exécutée une seule fois au début */
    
    // Ces deux lignes font exécuter des fonctions à intervalle régulier
    Temporisateur_Clignotant.attach(&Tache_Clignotant, 0.25);
    Temporisateur_Essuie_Glace.attach(&Tache_Essuie_Glace, 0.01);
    
    // Fait exécuter une fonctions quand on appui sur le bouton du clignotant d'urgence
    Bouton_Clignotant_Urgence.rise(&Activer_Desactiver_Clignotant_Urgence);

    
    /* Boucle principale - Exécutée tanc que le microcontrôleur fonctionne */
    while(1)                
    {
        
        if (Pedale_Frein)   // Allumer les lumières de freins quand on appui sur la pédale
        {
            Lumiere_Frein_1 = 1;
            Lumiere_Frein_2 = 1;
        }
        else                // Éteindre les lumières de freins quand la pédale est relâchée
        {
            Lumiere_Frein_1 = 0;
            Lumiere_Frein_2 = 0;
        }
    }
}
