#include <stdio.h>

#include "mbed.h"
#include "VL53L1X_I2C.h"
#include "VL53L1X_Class.h"
#include "LED_WS2812.h"

#define VL53L1_I2C_SDA   D14
#define VL53L1_I2C_SCL   D15

static VL53L1X *sensor = NULL;
Serial pc(SERIAL_TX, SERIAL_RX);

/* flags that handle interrupt request for sensor and user blue button*/
volatile bool int_sensor = false;
volatile bool int_stop = false;


/* ISR callback function of the sensor */
void sensor_irq(void)
{
    int_sensor = true;
    sensor->disable_interrupt_measure_detection_irq();
}

/* ISR callback function of the user blue button to switch measuring sensor. */
void measuring_stop_irq(void)
{
    int_stop = true;
}

/* Start the sensor ranging */
int start_ranging()
{
    int status = 0;
    /* start the measure on the sensor */
    if (NULL != sensor) {
        status = sensor->stop_measurement();
        if (status != 0) {
                return status;
        }

        status = sensor->start_measurement(&sensor_irq);
        if (status != 0) {
            return status;
        }
    }
    return status;
}

int range_measure(VL53L1X_DevI2C *device_i2c)
{
    int status = 0;
    uint16_t distance = 0;
    int distance_close = 0;
    
    LED_WS2812 LED(A0,12);
    LED.SetIntensity(5);
    LED.SetColor(BLACK);
    
    /* Create a xshutdown pin */
    DigitalOut xshutdown(D10);

    /* create instance of sensor class */
    sensor = new VL53L1X(device_i2c, &xshutdown, D11);

    sensor->vl53l1_off();
    /* initialise sensor */
    sensor->init_sensor(0x52);

    if (status) {
        delete sensor;
        sensor= NULL;
        printf("Sensor centre not present\n\r");
    }
    status = sensor->vl53l1x_set_timing_budget_in_ms(100); // good trade off between accuracy and power consumption
    status = sensor->vl53l1x_set_inter_measurement_in_ms(500); // perform one ranging every second
    status = sensor->vl53l1x_set_distance_threshold(1900, 1900, 0, 0); // interrupt if distance < 1.9 m (~6 feet)
    status = start_ranging();
    if (status != 0) {
        printf("Failed to start ranging!\r\n");
        return status;
    }
    if (NULL != sensor) {
        printf("Entering loop mode\r\n");
        /* Main ranging interrupt loop */
        while (true) {
            if (int_sensor) {
                distance_close = 1;
                int_sensor = false;
                status = sensor->handle_irq(&distance);
//                printf("distance: %d\r\n", distance);         
            }
            if (distance_close)
            {
                LED.InsertColor(RED);
                LED.StartBlink(0.2);
                wait_ms(500);
                LED.StopBlink();
                distance_close = 0;
            }
            else
            {
                LED.SetColor(GREEN);
                wait_ms(500);
            }
        }
    }

    return status;

}


/*=================================== Main ==================================
=============================================================================*/
int main()
{
#if TARGET_STM  // we are cross compiling for an STM32-Nucleo    
    InterruptIn stop_button(USER_BUTTON);
    stop_button.rise(&measuring_stop_irq);
#endif
#if TARGET_Freescale // we are cross-compiling for NXP FRDM boards.
    InterruptIn stop_button(SW2);
    stop_button.rise(&measuring_stop_irq);
#endif
    VL53L1X_DevI2C *device_i2c = new VL53L1X_DevI2C(VL53L1_I2C_SDA, VL53L1_I2C_SCL);
    range_measure(device_i2c);  // start continuous measures
}
