#ifndef ZOMBIE_H
#define ZOMBIE_H

// Headers -------------------------------------------------------------
#include "mbed.h"
#include "Joystick.h"
#include "N5110.h"
#include "Positioning.h"


/** Zombie Class
 * @brief Draws and moves Zombie Sprites
 * @author William Hardie, University of Leeds
 * @date March 2020
 */
 
class Zombie: public Positioning 
{
public:
    
    /** Constructor */
    Zombie();
    
    /** Destructor */
    ~Zombie();
    
    /** Initialise Zombie */
    void init();
    
    /** Draw Zombie
     * @param lcd @details N5110 object
     */
    void draw(N5110 &lcd);
    
    
    
private:
    
    //Random y position 
    int random_spawn;



};
#endif
    