#include "Zombie.h"
#include "Joystick.h"
#include "N5110.h"

// Constant Definitions
#define ZOMBIE_X_LENGTH 7
#define ZOMBIE_Y_LENGTH 10
#define ZOMBIE_DEATH_X_LENGTH 10
#define ZOMBIE_DEATH_Y_LENGTH 11
#define STARTING_X_POS 77



// Nothing doing in the constructor and destructor
Zombie::Zombie() {

}

Zombie::~Zombie() {
    
}

//Zombie sprite for even x positions
const int zombie_sprite_even[ZOMBIE_Y_LENGTH][ZOMBIE_X_LENGTH] = {
    {0,0,0,1,1,0,0},
    {0,0,0,1,1,0,0},
    {1,1,1,1,1,1,0},
    {0,0,0,1,1,1,0},
    {0,1,1,1,1,1,0},
    {0,0,0,0,1,1,0},
    {0,0,0,0,1,1,0},
    {0,0,0,1,1,1,0},
    {0,0,1,1,0,0,1},
    {0,0,0,0,0,1,1},
};

//zombie Sprite for odd x positions
const int zombie_sprite_odd[ZOMBIE_Y_LENGTH][ZOMBIE_X_LENGTH] = {
    {0,0,0,1,1,0,0},
    {0,0,0,1,1,0,0},
    {0,1,1,1,1,1,0},
    {0,0,0,1,1,1,0},
    {1,1,1,1,1,1,0},
    {0,0,0,1,1,1,0},
    {0,0,0,0,1,1,0},
    {0,0,0,0,1,1,0},
    {0,0,0,1,1,0,1},
    {0,0,0,0,0,1,1},
};


//Initialises zombie class
void Zombie::init() {
    // Sets defined values to variables
    x_pos = STARTING_X_POS;
    y_pos = (rand() %30) + 1;

 
    //printf("%d\n", zombie_y_pos);
}

//draws zombie class
void Zombie::draw(N5110 &lcd) {
        //Draws 'even' zombie sprite when x value is even
        if(x_pos % 2){
            lcd.drawSprite(x_pos, y_pos, ZOMBIE_Y_LENGTH, ZOMBIE_X_LENGTH, (int*)zombie_sprite_even);
            }
        //Draws 'odd' zombie sprite when x value is odd
        else {
            lcd.drawSprite(x_pos, y_pos, ZOMBIE_Y_LENGTH, ZOMBIE_X_LENGTH, (int*)zombie_sprite_odd);
            }
        walking();
}

    

