#ifndef POSITIONING_H
#define POSITIONING_H

//Headers-----------------------------------------------------------------------
#include "mbed.h"
#include "Joystick.h"



/** Positioning Class
 * @brief Positioning Class
 * @author William Hardie, University of Leeds
 * @date March 2020
 */
 
class Positioning {
    
    public:
    
        /** Gets Position */
        //Accessor
        Vector2D get_position();
        
        /** Sets Position */
        void set_position(int x_new_pos);
         
        /** Controls Zombie Movement */
        void walking();
        
        /** Creates random y position spawn for zombie */
        void random_number_generator();
        

         
    protected:
        
        //X and Y position values
        int x_pos;
        int y_pos;
        
        //Incrementing value for zombie walking
        int n;


};

#endif
     