#ifndef MENU_H
#define MENU_H

// Headers -------------------------------------------------------------
#include "mbed.h"
#include "Joystick.h"
#include "N5110.h"


/** Menu Class
 * @brief Creates Menu Options
 * @author William Hardie, University of Leeds
 * @date April 2020
 */
 
class Menu 
{
public:
    
    /** Constructor */
    Menu();
    
    /** Destructor */
    ~Menu();
    
    /** Initialise Menu */
    void init();
    
    /** Draw Menu Options
     * @param lcd @details N5110 object
     */
    void draw(N5110 &lcd);
    //void draw_arrow(N5110 &lcd);
    
    void draw_tutorial(N5110 &lcd);
    
    void draw_settings(N5110 &lcd);
    
    /** Changing Selector Position */
    void selection(Direction direction);
    
    /** Get 2D Vector of Joystick */
    Vector2D get_pos();
    
    //Scrolling
    void scroller(Direction direction);
    
    //Keeps arrow cycling through options
    void stop_arrow_off_screen();
    
    //Arrow position accessor
    int get_arrow_y_pos();
    
    //Tutorial page accessor
    int get_tutorial_page();
    
    //Tutorial page mutator
    void set_tutorial_page(int new_tutorial_page);
    
    //settings page accessor
    int get_settings_page();
    
    //Settings page mutator
    void set_settings_page(int new_settings_page);
    
private:
    
    //Settings rectangle values
    int rectangle_width;
    int rectangle_height;
    
    //Arrow y value
    int arrow_y_pos;
    
    //tutorial page number
    int tutorial_page_number;
    
    //settings page number
    int settings_page_number;
    
    

};
#endif
    