#include "Menu.h"
#include "Joystick.h"
#include "N5110.h"

// Constant Definitions
#define ARROW_X_LENGTH 11
#define ARROW_Y_LENGTH 9

//Setting pins to Pots
AnalogIn pot0(p20);
AnalogIn pot1(p19);



// Nothing doing in the constructor and destructor
Menu::Menu() {

}

Menu::~Menu() {
    
}

//Arrow Sprite
const int arrow_sprite[ARROW_Y_LENGTH][ARROW_X_LENGTH] = {
    {0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,0,0},
    {0,0,0,1,1,0,0,0,0,0,0},
    {0,0,1,1,1,1,1,1,1,1,1},
    {0,1,1,1,1,1,1,1,1,1,1},
    {0,0,1,1,1,1,1,1,1,1,1},
    {0,0,0,1,1,0,0,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0},

};

//ZOMBIE Letter Sprites
const int letter_z[8][7] = {
    {1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1},
    {1,1,0,0,1,1,1},
    {0,0,1,1,1,1,0},
    {0,1,1,1,1,1,0},
    {1,1,1,1,0,0,1},
    {1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1},
};

const int letter_o[8][7] = {
    {0,0,1,1,1,0,0},
    {0,1,1,1,1,1,0},
    {1,1,1,1,1,1,1},
    {1,1,1,0,1,1,1},
    {1,1,1,0,1,1,1}, 
    {1,1,1,1,1,1,1},
    {0,1,1,1,1,1,0},
    {0,0,1,1,1,0,0},
};

const int letter_m[8][9] = {
    {0,1,1,0,0,0,1,1,0},
    {1,1,1,1,0,1,1,1,1},
    {1,1,1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1,1,1},
    {1,1,1,0,1,0,1,1,1},
    {1,1,1,0,0,0,1,1,1},
    {1,1,1,0,0,0,1,1,1},
};

const int letter_b[8][7] = {
    {1,1,1,1,1,1,0},
    {1,1,1,1,1,1,1},
    {1,1,0,0,1,1,1},
    {1,1,1,1,1,1,0},
    {1,1,1,1,1,1,0},
    {1,1,0,0,1,1,1},
    {1,1,1,1,1,1,1},
    {1,1,1,1,1,1,0},
};

const int letter_i[8][7] = {
    {1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1},
    {1,0,1,1,1,0,1},
    {0,0,1,1,1,0,0},
    {0,0,1,1,1,0,0},
    {1,0,1,1,1,0,1},
    {1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1},

};

const int letter_e[8][7] = {
    {1,1,1,1,1,1,0},
    {1,1,1,1,1,1,1},
    {1,1,0,0,0,1,1},
    {1,1,1,1,0,0,0},
    {1,1,1,1,0,0,0},
    {1,1,0,0,0,1,1},
    {1,1,1,1,1,1,1},
    {1,1,1,1,1,1,0},
};

//Target logo sprite
const int target_logo[12][12] = {
    {0,0,0,1,1,1,1,1,1,0,0,0},
    {0,0,1,1,0,1,1,0,1,1,0,0},
    {0,1,1,0,0,1,1,0,0,1,1,0},
    {1,1,0,0,0,1,1,0,0,0,1,1},
    {1,0,0,0,0,1,1,0,0,0,0,1},
    {1,1,1,1,1,0,0,1,1,1,1,1},
    {1,1,1,1,1,0,0,1,1,1,1,1},
    {1,0,0,0,0,1,1,0,0,0,0,1},
    {1,1,0,0,0,1,1,0,0,0,1,1},
    {0,1,1,0,0,1,1,0,0,1,1,0},
    {0,0,1,1,0,1,1,0,1,1,0,0},
    {0,0,0,1,1,1,1,1,1,0,0,0},
};
    
//Initialises the menu
void Menu::init() {
    
    //Sets initial arrow position
    arrow_y_pos = 15;
    
    //Sets initial page numbers
    tutorial_page_number = 1;
    
    settings_page_number = 1;
    
}

//Draws menu screen
void Menu::draw(N5110 &lcd) {
    
    //Prints menu title
    lcd.drawSprite(8,2,8,7,(int*)letter_z);
    lcd.drawSprite(17,2,8,7,(int*)letter_o);
    lcd.drawSprite(26,2,8,9,(int*)letter_m);
    lcd.drawSprite(37,2,8,7,(int*)letter_b);
    lcd.drawSprite(46,2,8,7,(int*)letter_i);
    lcd.drawSprite(55,2,8,7,(int*)letter_e);
    lcd.drawSprite(64,0,12,12,(int*)target_logo);
    lcd.drawLine(8,11,64,11,2);
    lcd.drawLine(9,12,65,12,2);
    
    //Prints menu options
    lcd.printString("Play Game", 10, 2);
    lcd.printString("Tutorial", 10, 3);
    lcd.printString("Settings", 10, 4);
    
    //Keeps menu arrow cycling through options
    stop_arrow_off_screen();
    lcd.drawSprite(65, arrow_y_pos, ARROW_Y_LENGTH, ARROW_X_LENGTH, (int*)arrow_sprite);
    

}

//Function for scrolling through the menu with the arrow
void Menu::scroller(Direction direction) {
        
        if(direction == NW || direction == N || direction == NE) {
            arrow_y_pos -= 8;
            wait(0.3);
            
        }
        else if (direction == SW || direction == S || direction == SE) {
            arrow_y_pos += 8;
            wait(0.3);
        }
        else if (direction == W || direction == CENTRE || direction == E) {
            arrow_y_pos = arrow_y_pos;
        }
        
} 

//Stops arrow from moving out of bounds
void Menu::stop_arrow_off_screen() {
    
    // Stops crosshair leaving y boundaries
    if (arrow_y_pos > 31) {
        arrow_y_pos = 15;
        }
    else if (arrow_y_pos < 15) {
        arrow_y_pos = 31;
        }
}

//Arrow y pos Accessor    
int Menu::get_arrow_y_pos(){
    return arrow_y_pos;
    }

//Draws tutorial pages
void Menu::draw_tutorial(N5110 &lcd) {
    
    //Next Page Button
    if(tutorial_page_number <= 9) {
        lcd.drawLine(0,38,84,38,1);
        lcd.printString("Next page (A)", 4, 5);
        }
    if(tutorial_page_number >= 10) {
        tutorial_page_number = 10;
        lcd.printString("Back to", 10, 1);
        lcd.printString("Menu (A)", 15, 2);
        }
    
    //Page 1
    if(tutorial_page_number == 1) {
        lcd.printString("Welcome", 10, 1);
        lcd.printString("survivor...", 15, 2);
        }
    
    //Page 2
    if(tutorial_page_number == 2) {
        lcd.printString("The Zombie", 10, 1);
        lcd.printString("Apocalypse", 10, 2);
        lcd.printString("is upon us...", 10, 3);
        }
    
    //Page 3
    if(tutorial_page_number == 3) {
        lcd.printString("Armed with a", 3, 0);
        lcd.printString("sniper you", 3, 1);
        lcd.printString("must protect", 3, 2);
        lcd.printString("your house...", 3, 3);
        }
    
    //Page 4
    if(tutorial_page_number == 4) {
        lcd.printString("your partner,", 0, 0);
        lcd.printString("kids...", 0, 1);
        lcd.printString("and the WORLD", 0, 2);
        lcd.printString("rely on YOU!", 0, 3);
        }
        
    //Page 5
    if(tutorial_page_number == 5) {
        lcd.printString("Press (A) ", 5, 0);
        lcd.printString("to shoot", 15, 1);
        lcd.printString("Press (B)", 5, 2);
        lcd.printString("to reload", 15, 3);
        }
        
    //Page 6
    if(tutorial_page_number == 6) {
        lcd.printString("Kill count", 5, 0);
        lcd.printString("is shown", 5, 1);
        lcd.printString("in the top", 5, 2);
        lcd.printString("left corner", 5, 3);
        }
    
    //Page 7
    if(tutorial_page_number == 7) {
        lcd.printString("If you get", 5, 0);
        lcd.printString("40 kills you", 5, 1);
        lcd.printString("earn a ", 5, 2);
        lcd.printString("tactical nuke", 5, 3);
        }
    
    //Page 8
    if(tutorial_page_number == 8) {
        lcd.printString("Press (C) ", 10, 1);
        lcd.printString("to deploy", 10, 2);
        lcd.printString("nuke", 10, 3);
        }
        
    //Page 9
    if(tutorial_page_number == 9) {
        lcd.printString("Good Luck", 10, 1);
        lcd.printString("soldier!", 15, 2);
        }
        
        
    }     
    
      
//Tutorial page Accessor
int Menu::get_tutorial_page() {
    return tutorial_page_number;
    }

//Tutorial page Mutator
void Menu::set_tutorial_page(int new_tutorial_page){
    tutorial_page_number = new_tutorial_page;
    }

//Settings page Accessor
int Menu::get_settings_page() {
    return settings_page_number;
    }

//Settings page Mutator
void Menu::set_settings_page(int new_settings_page){
    settings_page_number = new_settings_page;
    }

//Draws settings pages
void Menu::draw_settings(N5110 &lcd) {
    
    float pot0_val = pot0.read();
    float pot1_val = pot1.read();
    
    int contrast_rectangle = int(pot0_val*50.0f); // convert to an int in the range 0.0 to 50.0
    int sfx_rectangle = int(pot1_val*50.0f);
    
    //int contrast_value = int(pot0_val*0.2f + 0.4);
    //lcd.setContrast(contrast_value);
    
    //Next Page Button
    if(settings_page_number <= 2) {
        lcd.drawLine(0,38,84,38,1);
        lcd.printString("Next page (A)", 4, 5);
        }
    if(settings_page_number >= 3) {
        tutorial_page_number = 3;
        lcd.printString("Back to", 10, 1);
        lcd.printString("Menu (A)", 15, 2);
        }
    
    //Page 1
    if(settings_page_number == 1) {
        lcd.printString("Please turn", 8, 0);
        lcd.printString("off switches", 3, 1);
        lcd.printString("s0 & s1 to ", 11, 2);
        lcd.printString("use settings", 3, 3);
        }
    
    //Page 2
    if (settings_page_number == 2) {
        
        //Titles
        lcd.printString("Contrast (p0):", 0, 0);
        lcd.printString("SFX (p1):", 15, 2);
        
        //Box Outlines
        lcd.drawRect(17,8,51,6,FILL_TRANSPARENT);
        lcd.drawRect(17,25,51,6,FILL_TRANSPARENT);
        
        //Inner Rectangles
        lcd.drawRect(18,9,contrast_rectangle,4,FILL_BLACK); 
        lcd.drawRect(18,26,sfx_rectangle,4,FILL_BLACK);
        
        }
        
    }     
    