#ifndef House_H
#define House_H

// Headers -------------------------------------------------------------
#include "mbed.h"
#include "N5110.h"


/** House Class
 * @brief Draws and Edits House
 * @author William Hardie, University of Leeds
 * @date March 2020
 */
 
class House {
public:
    
    /** Constructor */
    House();
    
    /** Destructor */
    ~House();
    
    /** Initialise HUD */
    void init();
    
    /** Draw HUD
     * @param lcd @details N5110 object
     */
    void draw(N5110 &lcd);
    
    
private:
    
    //Value for house health
    int house_health;


};
#endif
    