#ifndef HUD_H
#define HUD_H

// Headers -------------------------------------------------------------
#include "mbed.h"
#include "N5110.h"

/** HUD Class
 * @brief Draws and Edits HUD
 * @author William Hardie, University of Leeds
 * @date March 2020
 */
 
class HUD {
public:
    
    /** Constructor */
    HUD();
    
    /** Destructor */
    ~HUD();
    
    /** Initialise HUD */
    void init();
    
    /** Draw HUD
     * @param lcd @details N5110 object
     */
    void draw(N5110 &lcd);
    
    //Draws bullets
    void draw_bullets(N5110 &lcd);
    
    //House Health Mutator
    void set_house_health(int new_house_health);
    
    //House Health Accessor
    int get_house_health();
    
    //Decrements bullet count by 1
    void bullet_shot();
    
    //Sets number of bullets to 10
    void reload();
    
    //Bullet number accessor
    int get_number_of_bullets();
    
    //Kill count accessor
    int get_number_of_kills();
    
    //Kill count mutator
    void set_number_of_kills(int new_number_of_kills);
    
    //Draws nuke
    void draw_tactical_nuke(N5110 &lcd);
    
    //Draws nuke in HUD
    void draw_small_nuke(N5110 &lcd);
    
    //Draws points
    void draw_points(N5110 &lcd);
    
    //Points Accessor
    int get_number_of_points();
    
    //Points mutator
    void set_number_of_points(int new_points);
    
    
private:
    
    //Number of bullets
    int number_of_bullets;
    
    //Sets initial x value for bullet drawing
    int bullet_x_start_pos;
    
    //House health value
    int house_health;
    
    //Number of kills
    int number_of_kills;
    
    //Number of points
    int points;
    
    
    

};
#endif
    