#include "HUD.h"
#include "N5110.h"
#include<sstream> 

// Constant Definitions
#define HEART_X_LENGTH 5
#define HEART_Y_LENGTH 4
#define BULLET_Y_LENGTH 4
#define BULLET_X_LENGTH 3
#define NUKE_Y_LENGTH 15
#define NUKE_X_LENGTH 14
#define NUKE_SMALL_Y_LENGTH 4
#define NUKE_SMALL_X_LENGTH 7
#define STARTING_BULLETS 10



// Nothing doing in the constructor and destructor
HUD::HUD() {

}

HUD::~HUD() {
    
}

//Heart Sprite
const int heart_shape[HEART_Y_LENGTH][HEART_X_LENGTH] = {
    {0,1,0,1,0},
    {1,1,1,1,1},
    {0,1,1,1,0},
    {0,0,1,0,0},
};

//Bullet Sprite
const int bullet_shape[BULLET_Y_LENGTH][BULLET_X_LENGTH] = {
    {0,1,0},
    {1,1,1},
    {1,1,1},
    {1,1,1},
};

//Small nuke sprite
const int nuke_small_shape[NUKE_SMALL_Y_LENGTH][NUKE_SMALL_X_LENGTH] = {
    {0,1,1,1,1,0,1},
    {1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1},
    {0,1,1,1,1,0,1},
};

//Main nuke sprite
const int nuke_shape[NUKE_Y_LENGTH][NUKE_X_LENGTH] = {
    {0,0,0,0,0,0,1,1,0,0,0,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,0,0,0,0,0,0},
    {0,0,0,1,1,0,0,0,0,1,1,0,0,0},
    {0,1,1,1,1,1,0,0,1,1,1,1,1,0},
    {1,1,1,1,1,1,0,0,1,1,1,1,1,1},
    {1,1,1,1,1,0,0,0,0,1,1,1,1,1},
    {0,1,1,1,1,0,0,0,0,1,1,1,1,0},
    {0,0,1,1,0,0,0,0,0,0,1,1,0,0},
};

//Initialise HUD
void HUD::init() {
    
    // Sets defined values to variables
    number_of_bullets = STARTING_BULLETS;
    
    bullet_x_start_pos = 81;
    // Sets House Health 
    house_health = 20;
    
    //Initialising starting kills
    number_of_kills = 0;

    //Initialising starting points
    points = 0;
}

//Draws HUD
void HUD::draw(N5110 &lcd) {
       
        //          x0,y0,x1,y1,type
        
        //main HUD horizontal line
        lcd.drawLine(0, 41, 84, 41, 1);
        
        //house health RHS vertical line
        lcd.drawLine(30,41, 30, 48, 1);
        
        //Bullets LHS vertical line
        lcd.drawLine(43,41, 43, 48, 1);
        
        //           x0,y0,width,height,fill
        
        //House health box
        lcd.drawRect(1,43, 22,    4, FILL_TRANSPARENT);
        
        //Heart Shape
        lcd.drawSprite(24, 43, HEART_Y_LENGTH, HEART_X_LENGTH, (int*)heart_shape);
        
        //House health bar
        lcd.drawRect(2,44, house_health,    2, FILL_BLACK);
        
        //Points box Horizontal line
        lcd.drawLine(0,8, 17, 8, 1);
        
        //Points box Vertical line
        lcd.drawLine(18,0,18,8,1);
                
}
//Draws Bullets
void HUD::draw_bullets(N5110 &lcd) {
        
        //Function to iterate through x positions to draw bullets
        for (int i = bullet_x_start_pos; i >= 45; i = i - 4) {
            lcd.drawSprite(i, 43, BULLET_Y_LENGTH, BULLET_X_LENGTH, (int*)bullet_shape);
            }
        if (number_of_bullets == 0 ) {
            lcd.printString("Reload!(B)",20,0);
            
            }
}


//Reload Accessor
void HUD::reload() {
        number_of_bullets = 10;
        bullet_x_start_pos = 81;
        }


//Bullet shooting function
void HUD::bullet_shot(){
    bullet_x_start_pos -= 4;
    
    //stop number of bullets getting < 0
    if (number_of_bullets > 0) {
                        number_of_bullets--;
                        }
                    }
                    
//House Health Mutator
void HUD::set_house_health(int new_house_health){
    house_health = new_house_health;
    }

//House Health Accessor    
int HUD::get_house_health(){
    return house_health;
    }

//Number of bullets accessor
int HUD::get_number_of_bullets(){
    return number_of_bullets;
    }

//Number of kill accessor
int HUD::get_number_of_kills() {
    return number_of_kills;
    }

//Number of kills mutator
void HUD::set_number_of_kills(int new_number_of_kills){
    number_of_kills = new_number_of_kills;
    }
    
//Draw tactical nuke function
void HUD::draw_tactical_nuke(N5110 &lcd) {
        
    lcd.drawSprite(33, 10, NUKE_Y_LENGTH, NUKE_X_LENGTH, (int*)nuke_shape);
    lcd.drawCircle(40,18,10,FILL_TRANSPARENT);
    lcd.printString("Tactical Nuke",5,4);
    
    }
    
//Draw nuke small symbol in HUD Bar
void HUD::draw_small_nuke(N5110 &lcd) {
        
    lcd.drawSprite(34, 43, NUKE_SMALL_Y_LENGTH, NUKE_SMALL_X_LENGTH, (int*)nuke_small_shape);
    
    }

//Draws points at top left of screen
void HUD::draw_points(N5110 &lcd) {
    
    //Converting integer to string
    char buffer[3];  
    sprintf(buffer,"%.3d",points); 
    lcd.printString(buffer,0,0);
}

//Number of points accessor
int HUD::get_number_of_points() {
    return points;
    }

//Number of points mutator
void HUD::set_number_of_points(int new_points){
    points = new_points;
    }