#ifndef GAMEENGINE_H
#define GAMEENGINE_H

//Headers-----------------------------------------------------------------------
#include "Crosshair.h"
#include "Joystick.h"
#include "N5110.h"
#include "HUD.h"
#include "House.h"
#include "Zombie.h"
#include "Menu.h"
#include "stdio.h"
#include "stdlib.h"
#include <vector> 
#include "ShiftReg.h"


/** GameEngine Class
 * @brief Runs menu & main game
 * @author William Hardie, University of Leeds
 * @date March 2020
 */
 
class GameEngine {
    
    public:
         /** Constructor */
         GameEngine();
         
         /** Destructor */
         ~GameEngine();
         
         /** Initialise GameEngine */
         void init();
         
        /** Runs the Menu */
        void run_menu();
         
        /** Runs the Main Game */
        void play_game();
        
        /** Runs the Tutorial */
        void run_tutorial();
        
        /** Runs the Settings */
        void run_settings();
        
        /** Runs the Game Over */
        void run_game_over();
        
        //Menu selection flag accessor
        int get_menu_selection_flag();
        

    private:
    
//------------------------------------------------------------------------------
//DEFINITIONS
    
        /**Define Menu Object */
        Menu menu;
        
        /** Define Crosshair Object */
        Crosshair crosshair;

        /** Define Direction Object */
        Direction direction;
        
        /** Define HUD Object */
        HUD HUD;
        
        /** Define House Object */
        House house;
        
        /** Define Ticker Object */
        Ticker ticker;
        
        /** Define Shift Reg Object */
        ShiftReg shift;
        
//------------------------------------------------------------------------------

        //Checking zombie and house collision
        void check_zombie_house_collision();
        
        //Checks house health status
        void check_house_health();
        
        //Checking buttons
        bool check_A_pressed();
        
        bool check_B_pressed();
        
        bool check_C_pressed();
        
        //Counts number of bullets
        void count_number_of_bullets();
        
        //Function to set bullets to 10
        void reload();
    
        //Function to cycle through menu options
        void select_option();
        
        //Flag to choose different menu options        
        int menu_selection_flag;
        
        /** Vector to store each new zombie object*/
        std::vector<Zombie> zombie_vector;
        
        //Function which adds new zombies to vector
        void spawn_zombies();
        
        //Counts number of zombies which have spawned
        int spawn_zombie_counter;
        
        //Timer between zombie spawns
        int zombie_spawn_timer;
        
        int spawn_timer;
        
        //Draws zombies
        void draw_zombies();
        
        //Timer interrupt
        void zombie_timer_isr();
        
        //Timer flag
        volatile int zombie_timer_flag;
        
        //Goal state for timer
        int spawn_timer_goal;
        
        //Function to check if crosshair position is over zombie position
        void crosshair_aiming_at_zombie();
        
        //Deletes zombie if shot
        void zombie_is_shot(int i);
        
        //Board LEDs for charging up nuke
        void tactical_nuke_leds();
        
        //Flag for nuke
        int tactical_nuke_flag;
        
        //Function to set off nuke
        void deploy_tactical_nuke();
        
        //Draws zombie death animation
        void draw_zombie_death(N5110 &lcd, int i);
        
        //Score
        int score;
        
        
    
    
    
};

#endif
     