#ifndef CROSSHAIR_H
#define CROSSHAIR_H

// Headers -------------------------------------------------------------
#include "mbed.h"
#include "Joystick.h"
#include "N5110.h"
#include "Positioning.h"


/** Crosshair Class
 * @brief Draws and moves crosshair
 * @author William Hardie, University of Leeds
 * @date March 2020
 */
 
class Crosshair: public Positioning 
{
public:
    
    /** Constructor */
    Crosshair();
    
    /** Destructor */
    ~Crosshair();
    
    /** Initialise Crosshair */
    void init();
    
    /** Draw Crosshair
     * @param lcd @details N5110 object
     */
    void draw(N5110 &lcd);
    
    /** Changing Crosshair Position */
    void travel(Direction direction);
    
    /** Get 2D Vector of Joystick */
    Vector2D get_pos();
    
private:
       
    /** Sets x and y positions */
    void set_crosshair_pos(int change_in_x,int change_in_y);
    
    //Stops crosshair leaving bounds of screen
    void stop_crosshair_off_screen();

};
#endif
    