#include "Crosshair.h"
#include "Joystick.h"
#include "N5110.h"

// Constant Definitions
#define CROSSHAIR_X_LENGTH 5
#define CROSSHAIR_Y_LENGTH 5
#define STARTING_X_POS 40
#define STARTING_Y_POS 18


// Nothing doing in the constructor and destructor
Crosshair::Crosshair() {

}

Crosshair::~Crosshair() {
    
}

/**
//Old Crosshair Sprite

const int crosshair_sprite[CROSSHAIR_Y_LENGTH][CROSSHAIR_X_LENGTH] = {
    {0,0,1,0,0},
    {0,0,1,0,0},
    {1,1,0,1,1},
    {0,0,1,0,0},
    {0,0,1,0,0},
};
*/

//Intitialises the crosshair
void Crosshair::init() {
    // Sets defined values to variables
    x_pos = STARTING_X_POS;
    y_pos = STARTING_Y_POS;
}

//Draws crosshair and keeps on screen
void Crosshair::draw(N5110 &lcd) {
        
        //add in check if off screen function
        stop_crosshair_off_screen();
        
        //crosshair overlapping sprite:
        //lcd.drawSprite(x_pos, y_pos, CROSSHAIR_Y_LENGTH, CROSSHAIR_X_LENGTH, (int*)crosshair_sprite);
        
        //crosshair sprite using two lines:
        lcd.drawLine(x_pos , y_pos + 2, x_pos + 4, y_pos + 2,1); // horizontal line 
        lcd.drawLine(x_pos + 2, y_pos, x_pos + 2,y_pos + 4,1); // vertical line 
        
        //crosshair circular:
        //lcd.drawCircle(x_pos + 2, y_pos + 2, 2, FILL_TRANSPARENT);
        //lcd.drawLine(x_pos + 2, y_pos + 2, x_pos + 2, y_pos + 2, 1);
}

void Crosshair::travel(Direction direction) {
    //Uses joystick.cpp enum to change crosshair pos depending on joystick direction
    switch (direction) {
    
    case CENTRE: set_crosshair_pos(0, 0);
        break;
    case N: set_crosshair_pos(0, -1);
        break;
    case NE: set_crosshair_pos(1, -1);
        break;
    case E: set_crosshair_pos(1, 0);
        break;
    case SE: set_crosshair_pos(1, 1);
        break;
    case S: set_crosshair_pos(0, 1);
        break;
    case SW: set_crosshair_pos(-1, 1);
        break;
    case W: set_crosshair_pos(-1, 0);
        break;
    case NW: set_crosshair_pos(-1, -1);
        break;
    }
}

//Function to be used in travel function
void Crosshair::set_crosshair_pos(int change_in_x,int change_in_y) {
    x_pos += change_in_x;
    y_pos += change_in_y;
    
}

//Stops crosshair sprite leaving bounds of the screen
void Crosshair::stop_crosshair_off_screen() {
    
    // Stops crosshair leaving x boundaries
    if (x_pos > 80) {
        x_pos = 80;
        }
    else if (x_pos < 11) {
        x_pos = 11;
        }
        
    // Stops crosshair leaving y boundaries
    if (y_pos > 37) {
        y_pos = 37;
        }
    else if (y_pos < -1) {
        y_pos = -1;
        }
}
