/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Zhihao Gu
Username: el18zg
Student ID Number: 201189323
Date: Aug 2019
*/

///////// pre-processor directives ////////
#include "mbed.h"
#include "N5110.h"
#include "Bitmap.h"
#include "Gamepad.h"
#include "Rect.h"
#include "Screen.h"

#ifdef WITH_TESTING
#endif

/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Rect rect;
Screen screen;

///////////// prototypes ///////////////
void start();
void music();

///////////// functions ////////////////
int main() 
{
    #ifdef WITH_TESTING
    int failures = run_tests();
 
    if(failures > 0) return failures;
    #endif
    
    // initialise the lcd, pad 
    lcd.init();// initialise
    pad.init();
    rect.init_x0y0();
    start();// some time to start, show start screen
    printf("init the lcd, pad and rectangle");
}


// start menu screen shown
void start() 
{
    while(1) 
    {
        lcd.clear();
        lcd.printString("tic",35,1);//print tic tac toe on the screen
        lcd.printString("tac",35,2);
        lcd.printString("toe",35,3);
        lcd.printString("Press start",14,4);//print information about the game on screen
        lcd.refresh();
        music();// music
        printf("go into the introduction");
        
        // bright LED if the START has been pressed 
        while(pad.check_event(Gamepad::START_PRESSED) == true) 
        {
            pad.tone(780, 0.11);// audio feedback
            while(1) 
            {
                lcd.clear();
                lcd.printString("Control rect",0,0);////print information about the game on screen
                lcd.printString("using X,Y,A,B",0,1);
                lcd.printString("makes left,up,",0,2);
                lcd.printString("down,right,",0,3);
                lcd.printString("Press B",0,4);
                lcd.printString("to continue",0,5);
                printf("prepare to start the game");
                
                // bright LED if B has been pressed 
                while(pad.check_event(Gamepad::B_PRESSED) == true) 
                {
                    pad.tone(780, 0.11);// audio feedback
                    while(1) 
                    {
                        lcd.clear();
                        lcd.printString("Press X",20,2);//print information about the game on screen
                        lcd.printString("to play",20,3);
                        lcd.refresh(); 
                        printf("now start the game");
                        
                        // bright LED if X has been pressed 
                        if(pad.check_event(Gamepad::X_PRESSED) == true) 
                        {
                            pad.tone(780, 0.11);// audio feedback
                            // while loop to draw screen and check the direction
                            while(1)
                            {
                                lcd.clear();
                                screen.draw_screen(lcd);//print information about the game on screen
                                rect.draw_rect(lcd);
                                rect.check_direction(pad,lcd);
                                rect.make_x0y0();
                                lcd.refresh();
                                printf("lead to the game screen");
                            }
                        }
                        lcd.refresh();
                    }
                }
                lcd.refresh();
            }
        }
        lcd.refresh();
    }
}

// a piece of melody music
void music()
{
    pad.tone(639, 0.5);  
    wait(0.5);
    pad.tone(639, 0.25);  
    wait(0.25);
    pad.tone(599, 0.25);  
    wait(0.25);
    pad.tone(522, 0.5);  
    wait(0.5);
    pad.tone(522, 0.25);  
    wait(0.25);
    pad.tone(430, 0.25);  
    wait(0.25);
    pad.tone(576, 0.25);  
    wait(0.25);
    pad.tone(639, 0.25);  
    wait(0.25);
    pad.tone(576, 0.25);  
    wait(0.25);
    pad.tone(639, 0.25);  
    wait(0.25);
    pad.tone(382, 0.5);  
    wait(0.5);
    pad.tone(430, 0.5);  
    wait(0.5);
    pad.tone(430, 0.25);  
    wait(0.25);
    pad.tone(382, 0.25);  
    wait(0.25);
    pad.tone(430, 0.5);  
    wait(0.5);
    pad.tone(522, 0.5);  
    wait(0.5);
    pad.tone(765, 0.25);  
    wait(0.25);
    pad.tone(868, 0.25);  
    wait(0.25);
    pad.tone(639, 0.25);  
    wait(0.25);
    pad.tone(765, 0.25);  
    wait(0.25);
    pad.tone(576, 0.75);  
    wait(0.75);
    printf("input the music");
}
