#ifndef RECT_H
#define RECT_H

#include "mbed.h"
#include "N5110.h"
#include "Bitmap.h"
#include "Gamepad.h"

/** Rect Class
*@brief move the rectangle to up, down, left and right
*@author Zhihao Gu
*@date Aug 2019
*/

class Rect {
    
    public:
    
        /* Constructor */
        Rect();
        
        /* Destructor */
        ~Rect();
        
        /* initialise value about x0 and y0 */
        void init_x0y0();
        
        /** check the direction of rectangle moving
        *@param Gamepad, N5110
        *@param decide the direction of the rectangle moving
        */
        
        void check_direction(Gamepad &pad, N5110 &lcd);
        
        /** draw rectangle
        *@param make N5110
        *@param draw the rectangle using the function 
        */ 
        
        void draw_rect(N5110 &lcd);    
        
        /** make the position of _x0 and _y0
        *@return the position of _x0 and _y0
        */
        
        Vector2D make_x0y0();
        
    private: 
        
        float _x0;// initialise x0
        float _y0;// initialise y0
        
};

#endif