#include "Rect.h"

// nothing doing in the constructor and destructor

Rect::Rect() 
{ 

}

Rect::~Rect() 
{

}

// initialise the value of x0 and y0
void Rect::init_x0y0() 
{
    _x0 = 14;// initialise x0 value
    _y0 = 8;// initialise y0 value
    printf("get x0 and y0 value");
}

// check the direction of the rectangle moving
void Rect::check_direction(Gamepad &pad, N5110 &lcd) 
{
    if ( pad.check_event(Gamepad::A_PRESSED) == true && lcd.getPixel(_x0, _y0 + 16) == false ) 
    {
        _y0 = _y0 + 16;// rectangle moving down, y value increases
        pad.tone(780, 0.11);// audio feedback
        printf("rectangle moving down");
    }    
    if ( pad.check_event(Gamepad::Y_PRESSED) == true && lcd.getPixel(_x0, _y0 - 16) == false ) 
    {
        _y0 = _y0 - 16;// rectangle moving up, y value decreases
        pad.tone(780, 0.11);// audio feedback
        printf("rectangle moving up");
    }
    if ( pad.check_event(Gamepad::X_PRESSED) == true && lcd.getPixel(_x0 - 28, _y0) == false ) 
    {
        _x0 = _x0 - 28;// rectangle moving left, x value decreases
        pad.tone(780, 0.11);// audio feedback
        printf("rectangle moving left");
    }
    if ( pad.check_event(Gamepad::B_PRESSED) == true && lcd.getPixel(_x0 + 28, _y0) == false ) 
    {
        _x0 = _x0 + 28;// rectangle moving right, x value increases
        pad.tone(780, 0.11);// audio feedback
        printf("rectangle moving right");
    }
    if ( pad.check_event(Gamepad::START_PRESSED) == true && lcd.getPixel(_x0, _y0) == false )
    {
        _x0 = _x0;// rectangle not moving, x value not change
        _y0 = _y0;// rectangle not moving, y value not change
        pad.tone(780, 0.11);// audio feedback
        printf("rectangle not moving");
    }    
}

// draw the rectangle
void Rect::draw_rect(N5110 &lcd) 
{
     lcd.drawRect(_x0 - 8,_y0 - 4,16,8,FILL_TRANSPARENT);// draw the rectangle, use the top-left coordiate
     printf("draw rectangle");
}

// make the position of x0 and y0
Vector2D Rect::make_x0y0() 
{
    Vector2D b;// initialise b value
    b.x = _x0;// make the position of x0
    b.y = _y0;// make the position of y0
    return b;// return value b
}
