#ifndef PLAYER_H
#define PLAYER_H
 
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Player class
*@brief move the player to up, down, left and right
*@author Zhihao Gu
*@date Aug 2019
*/ 

class Player {

    public:
    
      /* Constructor */
      Player();
 
      /* Destructor */
      ~Player();
   
      /* initialise value about height and width */
      void init();
    
      /** draw player
      *@param make N5110
      *@param draw the player using the function 
      */ 
      void draw(N5110 &lcd);
    
      /** make the location of player 
      *@param Gamepad, N5110
      *@param determine the location of player
      */
      void make_loc(); 
   
      /** update the location of player 
      *@param Gamepad, N5110
      *@param update the location of player
      */
      void update(Direction d);

private:
 
      int _x;// initialise x value
      int _y;// initialise y value
      int _height;// initialise height 
      int _width;// initialise width
 
};
#endif