#ifndef ENGINE_H
#define ENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Chess.h"
#include "Screen.h"

/** Engine Class
@brief how to start this game
@author Zhihao Gu
@date August 2019
*/

class Engine {

  public:
    
    /* Constructor */
    Engine();

    /* Destructor */
    ~Engine();

    /* initialise the value */
    void init();
    
    /** move the rectangle and circle using the joystick
    * @param lcd @details N5110 
    */
    void read_input(Gamepad &pad);
    
    /** draw new circle and rectangle position on screen
    * @param lcd @details N5110 
    */
    void update(Gamepad &pad, N5110 &lcd);
    
    /** show four lines,circle and rectangle on screen
    * @param lcd @details N5110 
    */
    void draw(N5110 &lcd);
    
    /** decide who win the game 
    * check the result 
    * @param result @details Game result
    */
    void check_result(N5110 &lcd);
   
private:

    // initialise values
    int s;
    int chess[3][3];
    int result;
    int _i;
    int _j;
    int _x1;
    int _y1;
    int _current_row;
    int _current_col;
    
    Direction _d;
    Screen _screen;
   
};
#endif