#ifndef CHESS_H
#define CHESS_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Chess Class
@brief how to play chess
@author Zhihao Gu
@date Aug 2019
*/
class Chess
{
public:
    
    /** Constructor */
    Chess();

    /* Destructor */
    ~Chess();
    
    // initialise the value
    void init(int i, int j, int x1, int y1, int current_row, int current_col);
    
    // draw the chess
    void draw(N5110 &lcd);
    
    // update the chess
    void update(Direction d);
    
    // press the button
    void button_pressed(Gamepad &pad, N5110 &lcd);
    
    /** draw the chess screen 
    * @param chess screen @details chess
    */
    void determine_current_player();
    
    /** shift the player and AI mode 
    * @param player and AI mode @details mode
    */
    void shift_player(N5110 &lcd);
    
    /* make the AIchess */
    void AIchess(Gamepad &pad,N5110 &lcd);
    
private:
    
    // initialise value
    int _i;
    int _j;
    int _x1;
    int _y1;
    char x;
    char o;
    int current_row;
    int current_col;
    int _current_player;
    int chess[3][3];
    int _player;
    
    Direction _d;

};
#endif