#ifndef AICHESS_H
#define AICHESS_H
 
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
 
/** AIchess Class
@brief how to control the AIchess
@author Zhihao Gu
@date Aug 2019
*/
 
class AIChess {

  public:
    
    /* Constructor */
    AIChess();
    
    /* Destructor */
    ~AIChess();
    
    // initialise value
    void init();
    
    // draw the AIchess
    void draw(N5110 &lcd);
    
    // update the AIchess
    void update();
    
    // decide the location of the AIchess
    void make_loc();
    
    // make position of the AIchess
    Vector2D get_loc(); 
    
private:
    
    // initial values
    int _x;
    int _y;
    int _height;
    int _width;
    int _chess[3][3];
    
};

#endif