/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name: Ruby Smith
Username: el18rs
Student ID Number: 201259470
Date: 22/05/20
*/

// includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "TetrisGame.h"

// set defaults 
#define TETROMINO_WIDTH 4
#define TETROMINO_HEIGHT 4
// #define TETROMINO_SIZE 4
#define TETROMINO_SPEED 1
#define HEIGHT 48
#define WIDTH 84
// STRUCTS //

struct UserInput {
    Direction d;
    float mag;
};

// OBJECTS //

N5110 lcd;
Gamepad pad;
TetrisGame tetris;

// PROTOTYPES //

void init();
void update_game(UserInput input);
void render();
void welcome();
void exit_game();
void cancel_line();
int score = 0;

// int ScreenHeight = 84;
// int ScreenWidth = 48;

// FUNCTIONS // 

int main()
{
    int fps = 6; // 6 frames per second 
    
    init(); // initialise and display welcome screen
    welcome(); // wait for user to press start
    
    render(); // draw initial frame 
    wait(1.0f/fps); // wait one frame period 
    
// game loop
    while(1) {
        tetris.read_input(pad); // read input 
        tetris.update(pad);
        //play_game(); // update game state 
        render(); // render the display
        wait(1.0f/fps); // wait one frame period 
        break;
        
}
}
        
void exit_game() {
     lcd.clear();
     lcd.printString(" GAME OVER ",0, 3);
     lcd.refresh();
     wait(10);
     lcd.clear();
     lcd.printString(" press RESET ",0,6);
     lcd.refresh();
     exit(1.0);
}  

    
void cancel_line() {
        int count;
    for(int j=0; j<=46; j+=1) {
    for(int i=0; i<=82; i++) {
        if (lcd.getPixel(i,j)==0) {
            count=0;
            break;
        } else if (lcd.getPixel(i,j)==1){
            count ++;
              }
            }
        if(count==83) {
            count = 0;
            lcd.drawLine(0,j,82,j,0); // clear line
            score++;
            for(int x=0; x<=82; x++) {
                for(int y=j; y>=0; y--) {
                    lcd.setPixel(x,y,false);
                    lcd.setPixel(x,y+1);
                    }
                }
            }
        }
    

}


// initialise classes and libraries
void init() {
    lcd.init(); // initialise lcd 
    pad.init(); // initialise Gamepad
    
    // initialise the game with correct tetromino sizes etc
    tetris.init(0, WIDTH/2 - 2, HEIGHT, 1);
    
}

void render() { // draws each frame on the lcd 

    lcd.clear(); // clear screen
    tetris.draw(lcd); // re-draw 
    lcd.refresh(); // refresh screen
}

// welcome screen display
void welcome() {
    
    lcd.printString("      TETRIS      ",0,1);
    lcd.printString("    Press Start   ",0,4);
    lcd.refresh();
    
    // flash LEDs untile start button pressed
    while (pad.start_pressed() == false) {
        lcd.setContrast(pad.read_pot1());
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}
