#ifndef TETRISGAME_H
#define TETRISGAME_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Tetromino.h"

class TetrisGame 
{
    
    public:
    TetrisGame();
    ~TetrisGame();
    
    void init(int number, int x, int y, int speed);
    void read_input(Gamepad &pad);
    void update(Gamepad &pad);
    void draw(N5110 &lcd);
    //void play_game();
    void exit_game();
    void cancel_line();
    
    private:
    
    void check_wall_collision(Gamepad &pad);
    void check_tetromino_collisions();
    // void check_score(Gamepad &pad);
    
  //  void cancel_line(N5110 &lcd);
 //   void gameover(N5110 &lcd);
    
    Tetromino _p1;
    
    int _number;
    int _x;
    int _y;
    int _speed;
    int blocknumber;
    int blockArray[5];
    
    //_old_tetromino;
    
    // int _p1x;
    
    Tetromino _tetromino;
    
    Direction _d;
    float _mag;
};

#endif