#include "TetrisGame.h"

TetrisGame::TetrisGame()
{
    
}

TetrisGame::~TetrisGame()
{
    
}

void TetrisGame::init(int number, int x, int y, int speed)
{
    // initialise game parameters
    _number = blockArray[blocknumber];
    _x = x;
    _y = y;
    _speed = speed;
    
    _tetromino.init(_number, WIDTH/2 - 2, HEIGHT, _speed); // puts tetromino in middle SHOULD THIS INCLUDE ARRAY????
    
}


void TetrisGame::read_input(Gamepad &pad)
{
    _d = pad.get_direction();
    _mag = pad.get_mag();
}

void TetrisGame::draw(N5110 &lcd)
{
    // draw elements in lcd buffer 
    
    // board
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    
    _tetromino.draw(lcd, _number);
    
    
}

void TetrisGame::update(Gamepad &pad)
{
    // check_score(pad);
    
    // _p1.update(_d,_mag);
    _tetromino.update(_d,_mag);
    
    check_wall_collision(pad);
    check_tetromino_collisions();
}


void TetrisGame::check_wall_collision(Gamepad &pad)
{
    Vector2D tetromino_pos = _tetromino.get_pos();
    Vector2D tetromino_velocity = _tetromino.get_velocity();
    
    // check if hit floor
    if (tetromino_pos.y + 4 >= (HEIGHT-1) ) {
        
        tetromino_pos.y = (HEIGHT-1) - 4;
        tetromino_velocity.y = 0;
        
        pad.tone(750.0,0.1);
        
        cancel_line(); // check if line full and cancel + drop down if it is 
                
        _tetromino.init(_number, WIDTH/2 - 2, HEIGHT, _speed); // drop new shame
        
        blocknumber ++;
        if (blocknumber > 4) {
            blocknumber = 0;
            }
    }
    // check if hit roof
    else if (tetromino_pos.y <= 1) {
        
        exit_game();
                
    }
    
    // SAVE OLD SCREEN AND DROP NEW TETROMINO???? //
 // update tetromino parameters??   
}

void check_tetromino_collisions(Tetromino tetromino)
{
    Vector2D tetromino_pos = _tetromino.get_pos();
    Vector2D tetromino_velocity = _tetromino.get_velocity();

    if (
    (lcd.get_pixel(tetromino_pos.y + 4, tetromino_pos.x) = 1) || // not sure if it should be 4 or 5 ??? 
    (lcd.get_pixel(tetromino_pos.y + 4, tetromino_pos.x + 1) = 1) || 
    (lcd.get_pixel(tetromino_pos.y + 4, tetromino_pos.x + 2) = 1) ||
    (lcd.get_pixel(tetromino_pos.y + 4, tetromino_pos.x + 3) = 1)
    ) {
        tetromino_velocity.x = 0;
        
        pad.tone(1000.0,0.1);
        cancel_line();
        
        blocknumber ++ 
        if (blocknumber > 4) { blocknumber = 0; }
            
        _tetromino.init(_number, WIDTH/2 - 2, HEIGHT, _speed); // break to loop back or keep this ??
        
}
