#ifndef ENG_H
#define ENG_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Aim.h"
#include "Heston.h"
#include "Pup.h"
#include "Spikes.h"

// gap from edge of screen
#define GAP 2

class Eng
{

public:
    Eng();
    ~Eng();

    void init();
    void read_input(Gamepad &pad);
    void update(Gamepad &pad, int fire, N5110 &lcd);
    void draw(N5110 &lcd);
    
    void powerup(N5110 &lcd, Gamepad &pad);
    void print_score(N5110 &lcd);
    void print_strike(N5110 &lcd);
    
    void check_s_hit(Gamepad &pad);
    
    void tik();
    
private:

    void check_hit(Gamepad &pad, N5110 &lcd);
    //void check_miss(Gamepad &pad);
    //void print_scores(N5110 &lcd);
    
    Heston _h1;
    //Heston _h2;
    //Heston _h3;
     
    int _hest_width;
    int _hest_height;
    //int _ball_size;
    //int _speed;
    
    // positions
    int _h1x;
    //int _h2x;
    //int _h3x;
    //int _h2y;
    int _h1y;
    //int _h3y;
    
    Aim _aim;
    
    Pup _pup;
    
    int pupon;
    
    Direction _d;
    float _mag;
    
    int _tok;
    
    bool flag;
    bool spike_f;
    
    Spikes _s1;
    Spikes _s2;

};

#endif