
#include "Eng.h"
Eng::Eng()
{

}

Eng::~Eng()
{

}
// objects
//Gamepad pad;
//N5110 lcd;
Aim aim;
Heston heston;
Pup pup;
Spikes spikes;


void Eng::init()
{
    
    aim.init();
    heston.init();
    pup.init();
    spikes.init();
    pupon = 0;
    _tok = 0;
    flag = true;
    spike_f =false;


}

//void Eng::read_input(Gamepad &pad);
void Eng::update(Gamepad &pad, int fire, N5110 &lcd)
{
        int shot = fire;
        if (shot == 1){
            aim.draw(lcd, fire);
            lcd.refresh();
            check_hit(pad, lcd);   
        }
        
        int c_score = heston.checkscore();
        if (c_score%5 == 0 && flag == false){
            flag = true;
            powerup(lcd, pad);
        }
        if (c_score%5 == 1){
            flag = false;
        }
        
        int strikes = heston.checkstrike();
            
        
        heston.update(pad);
        aim.update(pad);
        
        if (spike_f == true){
            //spikes.update();
            _s1.update();
            _s2.update();
            check_s_hit(pad);
        }
}

void Eng::draw(N5110 &lcd)
{
    heston.draw(lcd);
    aim.draw(lcd, 0);
    if (pupon == 1){
        pup.draw(lcd, 0);
    }
    if (spike_f == true){
        _s1.draw(lcd);
        _s2.draw(lcd);
    }
    
}

void Eng::check_hit(Gamepad &pad, N5110 &lcd)
{
    Vector2D aim_pos = aim.get_pos();
    Vector2D h1_pos = heston.get_pos();
    Vector2D pup_pos = pup.get_pos();
    
    if (
        (aim_pos.y >= h1_pos.y) && //top
        (aim_pos.y <= h1_pos.y + 12) && //bottom
        (aim_pos.x >= h1_pos.x) && //left
        (aim_pos.x <= h1_pos.x + 11)  //right
    ) {
        heston.hit(pad);
        print_score(lcd);
        lcd.refresh();
    }
    else if (
        (pupon == 1) &&
        (aim_pos.y >= pup_pos.y) && //top
        (aim_pos.y <= pup_pos.y + 8) && //bottom
        (aim_pos.x >= pup_pos.x) && //left
        (aim_pos.x <= pup_pos.x + 8)  //right
    ) {
        pupon = 0;
        heston.set_speed(0);
        pad.led(2,1);
        pad.led(5,1);
    }
    else {
        heston.miss(pad);
        print_strike(lcd);
        lcd.refresh();
        }
wait(0.4);
pad.leds_off();
}

void Eng::powerup(N5110 &lcd, Gamepad &pad)
{
    Vector2D aim_pos = aim.get_pos();
    int x = aim_pos.x;
    int y = aim_pos.y;
    pup.position(x, y);
    pupon = 1;
}

void Eng::tik()
{
    _tok = _tok + 1;
    int rem = _tok%50;
    if (rem == 0){
        heston.set_speed(1);
        spike_f = true;
        _s1.position(1);
        _s2.position(2);
    }
}

void Eng::print_strike(N5110 &lcd)
{
    // get scores from paddles
    int g_score = heston.checkstrike();
 
    // print to LCD i
    char buffer1[14];
    sprintf(buffer1,"%2d",g_score);
    lcd.printString(buffer1,1,1);  // font is 8 wide, so leave 4 pixel gape from middle assuming two digits
}   

void Eng::print_score(N5110 &lcd)
{
    // get scores from paddles
    int g_score = heston.checkscore();
 
    // print to LCD i
    char buffer1[14];
    sprintf(buffer1,"%2d",g_score);
    lcd.printString(buffer1,1,1);  // font is 8 wide, so leave 4 pixel gape from middle assuming two digits
}   

void Eng::check_s_hit(Gamepad &pad){
    Vector2D s1_pos = _s1.get_pos();
    Vector2D s2_pos = _s2.get_pos();
    Vector2D aim_pos = aim.get_pos();
    
    if (
        (aim_pos.y >= s1_pos.y) && //top
        (aim_pos.y <= s1_pos.y + 4) && //bottom
        (aim_pos.x >= s1_pos.x) && //left
        (aim_pos.x <= s1_pos.x + 4)  //right
        ) {
         spike_f = false;
         spikes.hit(pad);
    }
    if (
        (aim_pos.y >= s2_pos.y) && //top
        (aim_pos.y <= s2_pos.y + 4) && //bottom
        (aim_pos.x >= s2_pos.x) && //left
        (aim_pos.x <= s2_pos.x + 4)  //right
        ) {
         spike_f = false;
         spikes.hit(pad);
    }
         
         
}
