#include "Aim.h"

const int boi [5][5] = 
{
    {0,0,1,0,0},
    {0,0,1,0,0},
    {1,1,0,1,1},
    {0,0,1,0,0},
    {0,0,1,0,0},
};

const int bang [5][5] = 
{
    {1,0,0,0,1},
    {0,1,0,1,0},
    {0,0,1,0,0},
    {0,1,0,1,0},
    {1,0,0,0,1},
};


Aim::Aim()
{

}

Aim::~Aim()
{

}


    

void Aim::init()
{
    _y = 5;  // y value on screen is fixed
    _x = 42;  // cant be past edge of screen
    _height = 5;
    _width = 5;
    //_state = 0;
   
}

void Aim::draw(N5110 &lcd, int state)
{
    // draw basket 
    bool _state = state;
    
    if (_state == 0){
    lcd.drawSprite(_x,_y,5,5,(int*)boi);
    }
    if (_state == 1){
    lcd.drawSprite(_x,_y,5,5,(int*)bang);
    }
}

void Aim::update(Gamepad &pad)
{
    Direction d = pad.get_direction();
    mag = pad.get_mag();
    
    _speed = int(mag*8.0f);  // scale is arbitrary, could be changed in future

    // update x value depending on direction of movement
    // North is decrement as origin is at the top-left so decreasing moves up
    if (d == N) {
        _y-=_speed;
    } else if (d == NE) {
        _x+=_speed;
        _y-=_speed;
    } else if (d == E) {
        _x+=_speed;
    } else if (d == SE) {
        _x+=_speed;
        _y+=_speed;
    } else if (d == S) {
        _y+=_speed;
    } else if (d == SW) {
        _x-=_speed;
        _y+=_speed;
    } else if (d == W) {
        _x-=_speed;
    } else if (d == NW) {
        _x-=_speed;
        _y-=_speed;
    }

    // check the x origin to ensure that the paddle doesn't go off screen
    if (_x < 1) {
        _x = 1;
    }
    if (_x > 84 - _width - 1) {
        _x = 84 - _width - 1;
    }
    // check the y origin to ensure that the sprite doesn't go off screen
    if (_y < 1) {
        _y = 1;
    }
    if (_y > 48 - _height - 1) {
        _y = 48 - _height - 1;
    }
}

Vector2D Aim::get_pos() {
    Vector2D p = {(_x+2),(_y+2)};
    return p;    
}


