/* 
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name:Joe Body
Username:el18jgb
Student ID Number:201215898
Date:11/03/2020
*/

// includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Aim.h"
#include "Heston.h"
#include "Eng.h"


// objects
Gamepad pad;
N5110 lcd;

Eng eng;


// flag - must be volatile as changes within ISR
// g_ prefix makes it easier to distinguish it as global
volatile int g_timer_flag = 0;

// function prototypes
void timer_isr();


void init();
void render();
//void draw(N5110 &lcd);
//void read_input(Gamepad &pad);

int main()
{
    int fps = 10;  // frames per second
    int A_timer = 0;
    init();     // initialise and then display welcome screen...
    
    render();  // first draw the initial frame 
    wait(1.0f/fps);  // and wait for one frame period
    while (1) {
        //read_input(pad);
        int fire = 0;
        if (A_timer <= 0){
            fire = 0;
            if (pad.A_held()){
                fire = 1;
                A_timer = 6;
            }
        }
        

        eng.update(pad, fire, lcd);
        render();
        wait(1.0f/fps);
        
        A_timer--;
        
        eng.tik();
    }
    
}

// initialies all classes and libraries
void init()
{
    // need to initialise LCD and Gamepad 
    lcd.init();
    pad.init();

    eng.init();

}

// this function draws each frame on the LCD
void render()
{
    // clear screen, re-draw and refresh
    lcd.clear(); 

    eng.draw(lcd);
    lcd.refresh();
}

//void read_input(Gamepad &pad)
//{
    //int _d = pad.get_direction();
    //float _mag = pad.get_mag();
//}
