#include "Heston.h"

const int hest [12][11] = 
{
    {0,0,1,1,1,1,1,1,1,0,0},
    {0,1,0,0,0,0,0,0,0,1,0},
    {1,1,1,1,1,1,1,1,1,1,1},
    {1,0,1,0,1,0,1,0,1,0,1},
    {1,0,1,1,1,0,1,1,1,0,1},
    {0,1,0,0,0,1,0,0,0,1,0},
    {0,1,0,0,1,1,1,0,0,1,0},
    {0,1,0,0,0,0,0,0,0,1,0},
    {0,1,0,1,1,1,1,1,0,1,0},
    {0,0,1,0,1,1,1,0,1,0,0},
    {0,0,1,0,0,0,0,0,1,0,0},
    {0,0,0,1,1,1,1,1,0,0,0},
    
};


Heston::Heston()
{

}

Heston::~Heston()
{

}


    

void Heston::init()
{
    _y = 24;  // y value on screen is fixed
    _x = 42;  // cant be past edge of screen
    _height = 11;
    _width = 12;
    score = 0;
    strike = 10;
   _speed = 1;  // scale is arbitrary, could be changed in future
}

void Heston::draw(N5110 &lcd)
{
    // draw basket 
    
    lcd.drawSprite(_x,_y,12,11,(int*)hest);
}

void Heston::update(Gamepad &pad)
{
    
    

    // generate random number between 1 and 8: 
    d = rand() % 8 + 1;
    
    
    // update x value depending on direction of movement
    // North is decrement as origin is at the top-left so decreasing moves up
    if (d == 1) {
        _y+=_speed;
    } else if (d == 2) {
        _x+=_speed;
        _y+=_speed;
    } else if (d == 3) {
        _x+=_speed;
    } else if (d == 4) {
        _x+=_speed;
        _y-=_speed;
    } else if (d == 5) {
        _y-=_speed;
    } else if (d == 6) {
        _x-=_speed;
        _y-=_speed;
    } else if (d == 7) {
        _x-=_speed;
    } else if (d == 8) {
        _x-=_speed;
        _y+=_speed;
    }

    // check the x origin to ensure that the sprite doesn't go off screen
    if (_x < 1) {
        _x = 1;
    }
    if (_x > 84 - _width - 1) {
        _x = 84 - _width - 1;
    }
    // check the y origin to ensure that the sprite doesn't go off screen
    if (_y < 1) {
        _y = 1;
    }
    if (_y > 48 - _height - 1) {
        _y = 48 - _height - 1;
    }
}

Vector2D Heston::get_pos() {
    Vector2D p = {_x,_y};
    return p;    
}

void Heston::hit(Gamepad &pad)
{

    pad.led(3,1);
    pad.led(6,1);
    _x = rand() % 84 + 1;
    _y = rand() % 48 + 1;
    score+=1;
    
}

void Heston::miss(Gamepad &pad)
{

    pad.led(1,1);
    pad.led(4,1);
    strike-=1;

    
}

int Heston::checkscore()
{
    return score;
}

int Heston::checkstrike()
{
    return strike;
}

void Heston::set_speed(int state)
{
    if (state == 1){
        _speed = (_speed + 1);
        if (_speed == 8){
            _speed = 7;
        }
    }
    if (state == 0){
        _speed = (_speed - 2);
        if (_speed <= 0){
            _speed = 1;
        }
    }     
}
