/* Fish Eat Game v2.0
*   Author: Andrew Knowles
*   Date:   21/04/2021
*   Note: See hearder files for additional recognistion */  

#include "Settings.h"

//attach
BusOut RGB_led(p24,p23,p22); //RGB bus MSB - LSB, inverted logic 1 = low
DigitalIn button_A(p29);
DigitalIn button_B(p28);
DigitalIn button_C(p27);
DigitalIn button_D(p26);

//objects
ShiftReg shift;
HighScore _highscore;

//initialise all of the board
void Settings::systemINIT(N5110 &lcd, Tone &dac, Joystick &joystick){
    lcd.init();
    lcd.setBrightness(0.5);
    joystick.init();
    dac.init();
    shift.write(0x00);
    RGB_led.write(0b111);
    button_A.mode(PullNone);
    button_B.mode(PullNone);
    button_C.mode(PullNone);
    button_D.mode(PullNone);
    _highscore.writeFile(100);
}

int Settings::buttonA_state(int ButtonA){
    ButtonA = button_A.read();
    return ButtonA;
}

int Settings::buttonB_state(int ButtonA){
    ButtonB = button_B.read();
    return ButtonB;
}

//functions for changing settings
void Settings::settingsMenu(N5110 &lcd, Tone &dac, Joystick &joystick){
    rect_width = 32;

    do{
        lcd.clear();        
        lcd.drawRect(0,0,84,48,FILL_TRANSPARENT); //draws screen border
        lcd.printString("Use L & R to", 6, 1);
        lcd.printString("set contrast", 6, 2);
        
        if(joystick.get_direction() == E && rect_width < 64){
            rect_width = rect_width + 16;
        }else if(joystick.get_direction() == W && rect_width > 0){
            rect_width = rect_width - 16;
        }
        
        //contrast bar is 20 pixels high and 64 pixels long
        lcd.drawRect(10,30,64,5,FILL_TRANSPARENT); //draws outer rectangle
        lcd.drawRect(10,30,rect_width,5,FILL_BLACK); //draws inner rectangle
                    
        if(rect_width == 0){
            lcd.setBrightness(0.3);
            
        }else if(rect_width == 16){
            lcd.setBrightness(0.4);
            
        }else if(rect_width == 32){
            lcd.setBrightness(0.5);
            
        }else if(rect_width == 48){
            lcd.setBrightness(0.6);
            
        }else if(rect_width == 64){
            lcd.setBrightness(0.7);
        } 
        
        lcd.refresh();

        wait_ms(1000/10);
    }while(buttonB_state(ButtonB) == false);
}