/* Fish Eat Game v2.0
*   Author: Andrew Knowles
*   Date:   21/04/2021
*   Note: See hearder files for additional recognistion */  

#include "Graphics.h"

//draws title screen
void Graphics::titleScreen(N5110 &lcd){
    //draws an F x   y
    const int F[20][12] =   {
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    };

    //draws an I x   y
    const int I[20][4] =   {
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    { 1,1,1,1, },
    };

    //draws an s x   y
    const int S[20][12] =   {
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 0,0,0,0,0,0,0,0,1,1,1,1, },
    { 0,0,0,0,0,0,0,0,1,1,1,1, },
    { 0,0,0,0,0,0,0,0,1,1,1,1, },
    { 0,0,0,0,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    };

    //draws an h x   y
    const int H[20][12] =   {
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    };

    //draws an e x   y
    const int E[20][12] =   {
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,0,0,0,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    };

    //draws an a x   y
    const int A[20][12] =   {
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    { 1,1,1,1,0,0,0,0,1,1,1,1, },
    };

    //draws an t x   y
    const int T[20][12] =   {
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,0,0,0,0, },
    };
    
    lcd.drawRect(0,0,84,48,FILL_TRANSPARENT); //draws screen border
        
                 //pos  size
                 //X Y  row col
    lcd.drawSprite(16,2,20,12,(int *)F); 
    lcd.drawSprite(32,2,20,4,(int *)I); //xpos = prevoius x pos + col + 4
    lcd.drawSprite(40,2,20,12,(int *)S);
    lcd.drawSprite(56,2,20,12,(int *)H);
        
    lcd.drawSprite(19,26,20,12,(int *)E);
    lcd.drawSprite(35,26,20,12,(int *)A);
    lcd.drawSprite(51,26,20,12,(int *)T);   
}

//creates a confirmation screen to ensure that the player is ready
void Graphics::confirmationScreen(N5110 &lcd){
    //draws an uneaten fish  x   y
    const int Title_fish[44][21] =   {
    { 0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0, },
    { 0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0, },
    { 0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0, },
    { 0,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0, },
    { 0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0, },
    { 0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0, },
    { 0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0, },
    { 0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0, },
    { 0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0, },
    { 0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0, },
    { 0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0, },
    { 0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    };

    //draws an eaten fish      x   y
    const int Title_fish_eaten[44][21] =   {
    { 0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0, },
    { 0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0, },
    { 0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0, },
    { 0,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0, },
    { 0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0, },
    { 0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0, },
    { 0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0, },
    { 0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0, },
    { 0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0, },
    { 0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0, },
    { 0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0, },
    { 0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0, },
    { 0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0, },
    { 0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    };
    
    lcd.clear();
    lcd.drawRect(0,0,84,48,FILL_TRANSPARENT); //draws screen border
    lcd.printString("Hold",12,2);
    lcd.printString("B",24,3);
    lcd.drawSprite(59,2,44,21,(int*)Title_fish);
    lcd.refresh();
    wait_ms(1000);
    lcd.drawSprite(59,2,44,21,(int*)Title_fish_eaten);
    lcd.refresh();
    wait_ms(1000);
}

//flashes the screen using normal and inverse lcd functions
void Graphics::screenFlash(N5110 &lcd){
    i = 0;

    while(i<4){
        lcd.inverseMode();
        lcd.refresh();
        wait_ms(100);
        lcd.normalMode();
        lcd.refresh();
        wait_ms(100);
        i++;
    }
}

//displays playing instructions
void Graphics::playerInstruc(N5110 &lcd){
    lcd.clear();
    lcd.printString("-- Welcome --",3,0);
    lcd.printString("Use the",0,2);
    lcd.printString("joystick to ",0,3);
    lcd.printString("move the fish",0,4);
    lcd.refresh();
    wait_ms(4000);
        
    lcd.clear();
    lcd.printString("remember to",0,1);
    lcd.printString("only eat fish",0,2);
    lcd.printString("smaller than",0,3);
    lcd.printString("or same as",0,4);
    lcd.printString("you!!",0,5);
    lcd.refresh();   
    wait_ms(4000);
        
    lcd.clear();
    lcd.printString("At the top",0,1);
    lcd.printString("left youll",0,2);
    lcd.printString("see your",0,3);
    lcd.printString("growth bar...",0,4);
    lcd.refresh();
    wait_ms(4000);
        
    lcd.clear();
    lcd.printString("When this is",0,1);
    lcd.printString("full your fish",0,2);
    lcd.printString("will grow!!",0,3);
    lcd.refresh();
    wait_ms(4000);
        
    lcd.clear();
    lcd.printString("Be careful!",0,1);
    lcd.printString("Eat a bigger",0,2);
    lcd.printString("fish, you'll",0,3);
    lcd.printString("loose a life!",0,4);
    lcd.refresh();
    wait_ms(4000);
        
    lcd.clear();
    lcd.printString("Good Luck!!!",6,1);
    lcd.refresh();
    wait_ms(4000);
}

void Graphics::gameOver(N5110 &lcd){
    lcd.clear();
    lcd.drawRect(0,0,84,48,FILL_TRANSPARENT); //draws screen border
    lcd.printString("Game Over!!!",6,1);
    lcd.refresh();
    wait_ms(4000);
}

//displays congatulations screen
void Graphics::newHighscore(N5110 &lcd, int score){
    int displayScore = score;
    
                            //string            int
    stringCon2 = sprintf(writeScore2, "%i", displayScore); //converts int into string 
    lcd.clear();
    lcd.drawRect(0,0,84,48,FILL_TRANSPARENT); //draws screen border
    lcd.printString("New", 33, 1);
    lcd.printString("High Score", 14, 2);
    lcd.printString(writeScore2, 29, 4);
    lcd.refresh();
    wait_ms(4000);
}

void Graphics::Fish_1(N5110 &lcd, int _x, int _y){
    //             x  y
    const int Fish_1[4][9]= {
    { 1,0,0,1,1,1,1,1,0, },
    { 1,1,1,1,1,1,1,0,1, },
    { 1,1,1,1,1,1,1,1,1, },
    { 1,0,0,1,1,1,1,1,0, },
    };
    
    //pos / sprite x y / x  y
    lcd.drawSprite(_x,_y,4,9,(int*)Fish_1);
}

void Graphics::Fish_2(N5110 &lcd, int _x, int _y){
     //             x  y
    const int Fish_2[6][14] =   {
    { 1,0,0,0,0,1,1,1,1,1,1,1,0,0, },
    { 1,1,0,0,1,1,1,1,1,1,0,1,1,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,0,0,1,1,1,1,1,1,1,1,1,0, },
    { 1,0,0,0,0,1,1,1,1,1,1,1,0,0, },
    };
    
    //pos / sprite x y / x  y
    lcd.drawSprite(_x,_y,6,14,(int*)Fish_2);
}

void Graphics::Fish_3(N5110 &lcd, int _x, int _y){
    //             x  y
    const int Fish_3[8][17] =   {
    { 1,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0 },
    { 1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0 },
    { 1,1,1,0,0,1,1,1,1,1,1,1,1,0,1,1,0 },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
    { 1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,0 },
    { 1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0 },
    { 1,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0 },
    };
    
    //pos / sprite x y / x  y
    lcd.drawSprite(_x,_y,8,17,(int*)Fish_3);
}


void Graphics::Fish_4(N5110 &lcd, int _x, int _y){
    //             x  y
    const int Fish_4[12][23] =   {
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0, },
    { 1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0, },
    { 1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0, },
    { 1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0, },
    { 1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,0,0,1,1,1,1,1,1,1,0,1,0,1,1,1,1,1,1,0, },
    { 1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0, },
    { 1,1,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,1,1,1,1,0,0, },
    { 1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0, },
    };
    
    //pos / sprite x y / x  y
    lcd.drawSprite(_x,_y,12,23,(int*)Fish_4);
}

void Graphics::E_Fish_1(N5110 &lcd, int _x, int _y){
    //             x  y    
    const int E_Fish_1[4][9]= {
    { 0,1,1,1,1,1,0,0,1, },
    { 1,0,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1, },
    { 0,1,1,1,1,1,0,0,1, },
    };
    
    //pos / sprite x y / x  y
    lcd.drawSprite(_x,_y,4,9,(int*)E_Fish_1);
}

void Graphics::E_Fish_2(N5110 &lcd, int _x, int _y){
     //             x  y
    const int E_Fish_2[6][14] =   {
    { 0,0,1,1,1,1,1,1,1,0,0,0,0,1, },
    { 0,1,1,0,1,1,1,1,1,1,0,0,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 0,1,1,1,1,1,1,1,1,1,0,0,1,1, },
    { 0,0,1,1,1,1,1,1,1,0,0,0,0,1, },
    };
    
    //pos / sprite x y / x  y
    lcd.drawSprite(_x,_y,6,14,(int*)E_Fish_2);
}

void Graphics::E_Fish_3(N5110 &lcd, int _x, int _y){
    //             x  y
    const int E_Fish_3[8][17] =   {
    { 0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,1, },
    { 0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1, },
    { 0,1,1,0,1,1,1,1,1,1,1,1,0,0,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 0,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1, },
    { 0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1, },
    { 0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,1, },
    };
    
    //pos / sprite x y / x  y
    lcd.drawSprite(_x,_y,8,17,(int*)E_Fish_3);
}


void Graphics::E_Fish_4(N5110 &lcd, int _x, int _y){
    //             x  y
    const int E_Fish_4[12][23] =   {
    { 0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0, },
    { 0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1, },
    { 0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1, },
    { 0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1, },
    { 0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1, },   
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, },
    { 0,1,1,1,1,1,1,0,1,0,1,1,1,1,1,1,1,0,0,1,1,1,1, },
    { 0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1, },
    { 0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,0,0,0,0,0,0,1,1, },
    { 0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1, },
    };
    
    //pos / sprite x y / x  y
    lcd.drawSprite(_x,_y,12,23,(int*)E_Fish_4);
}