/* Fish Eat Game v2.0
*   Author: Andrew Knowles
*   Date:   21/04/2021
*   Note: See hearder files for additional recognistion */  

#ifndef GAME_H
#define GAME_H

#include "mbed.h"
#include "N5110.h"
#include "ShiftReg.h"
#include "Joystick.h"

#include "Graphics.h"
#include "Sound.h"

struct DIRECTION {
    Direction joy;
};

class Game {

public:
    
    //plays the game
    void gamePlay(N5110 &lcd, DIRECTION direction);
    
    //draws the playing area
    void init(N5110 &lcd, int x, int y, int Fish_size);
    
    //draws fish
    void drawFish(N5110 &lcd);
    
    //updates fish position
    void fishPos(DIRECTION direction);
    
    //Keeps score
    int Score(N5110 &lcd);
    
    //keeps track of lives
    int Lives();
    
    //check for collision with other fish
    void Collision();
    
    //generate enemy fish
    void enemyFish(N5110 &lcd);
    
private:
    int _x;
    int _y;
    int X;
    int Y;
    int i;
    int colour;
    int lives;
    int check_width;
    int rect_width;
    int barIncrement;
    int FISH_SIZE;
    int FISH_HEIGHT;
    int FISH_WIDTH;
    int E_FISH_HEIGHT;
    int E_FISH_WIDTH;
    int E_FISH;
    int collision;
    int x_bound;
    int y_bound;
    int check_score;
    int SCORE;
    int s_length;
    float centre_xpos;
    float centre_ypos;
    float CENTRE_X;
    float CENTRE_Y;
    float E_CENTRE_X;
    float E_CENTRE_Y;
    char _score[14];
    
};

#endif