/* Fish Eat Game v2.0
*   Author: Andrew Knowles
*   Date:   21/04/2021
*   Note: See hearder files for additional recognistion */  

#ifndef GRAPHICS_H
#define GRAPHICS_H

#include "N5110.h"

class Graphics {

public:
    //creates the game title screen
    void titleScreen(N5110 &lcd);
    
    //waits for player to press A
    void confirmationScreen(N5110 &lcd); 
    
    /*  If the ScreenFlash function doesnt operate as intended check that the LCD
    *   screen its self is seated correctly as this seems to be an issue*/
    
    //flashes LCD screen
    void screenFlash(N5110 &lcd); 
    
    //displays new high score screen
    void newHighscore(N5110 &lcd, int score);
    
    //displays playing instructions
    void playerInstruc(N5110 &lcd);
    
    //gameover screen
    void gameOver(N5110 &lcd);
    
    //player fish
    void Fish_1(N5110 &lcd, int _x, int _y); //draws fish 1 (smallest fish)
    void Fish_2(N5110 &lcd, int _x, int _y); //draws fish 2
    void Fish_3(N5110 &lcd, int _x, int _y); //draws fish 3
    void Fish_4(N5110 &lcd, int _x, int _y); //draws fish 4 (largest fish)
    
    //enemy fish
    void E_Fish_1(N5110 &lcd, int _x, int _y); //draws fish 1 (smallest fish
    void E_Fish_2(N5110 &lcd, int _x, int _y); //draws fish 2
    void E_Fish_3(N5110 &lcd, int _x, int _y); //draws fish 3
    void E_Fish_4(N5110 &lcd, int _x, int _y); //draws fish 4 (largest fish)
    
private:
    int i;
    char writeScore2[14];
    int stringCon2;
};

#endif