/* Fish Eat Game v2.0
*   Author: Andrew Knowles
*   Date:   21/04/2021
*   Note: See hearder files for additional recognistion */  

#ifndef FISHENGINE_H
#define FISHENGINE_H

#include "N5110.h"
#include "Tone.h"
#include "ShiftReg.h"
#include "Joystick.h"

#include "Game.h"
#include "Graphics.h"
#include "Settings.h"
#include "HighScore.h"

class FishEngine {

public:
    //calls the title sequence
    void titleSequence(N5110 &lcd);
    
    //calls the games main menu
    void mainMenu(N5110 &lcd, Tone &dac, Joystick &joystick);
    
    //calls game play from Game.h
    void gamePlay(N5110 &lcd, Joystick &joystick);
    
    //calls display_File(lcd) from HighScore.h
    void highScore(N5110 &lcd);
    
    //displays player instructions
    void Instructions(N5110 &lcd);
    
private:
    int ButtonA;
    int ButtonB; 
    int playerScore;
    int fileValue;
    int state;
    int direction;
    int y_pos;
};

#endif