/* Fish Eat Game v2.0
*   Author: Andrew Knowles
*   Date:   21/04/2021
*   Note: See hearder files for additional recognistion */   


#include "mbed.h"
#include "rtos.h" //allows multiple threads to run at the same time: https://os.mbed.com/handbook/RTOS

#include "FishEngine.h"
#include "Sound.h"
#include "Settings.h"

//Attach
N5110 lcd(p8,p9,p10,p11,p13,p21);
Joystick joystick(p20, p19);
Tone dac(p18);

//Objects
FishEngine fish;
Sound sound;
Settings settingsMain;
Thread thread;

void theme();

int main(){
    settingsMain.systemINIT( lcd, dac, joystick); //initialise board
    thread.start(theme);
    
    while(1){
        fish.titleSequence(lcd); //calls title sequence
        fish.mainMenu(lcd, dac, joystick);
    }
}

void theme(){
    sound.mainTheme(dac);
}