/* Fish Eat Game v2.0
*   Author: Andrew Knowles
*   Date:   21/04/2021
*   Note: See hearder files for additional recognistion */  

#include "Game.h"

//objects
ShiftReg _shift;
Graphics _graphics;
 
//attach
BusOut _RGB_led(p24,p23,p22); //RGB bus MSB - LSB, inverted logic 1 = low

//plays the game
void Game::gamePlay(N5110 &lcd, DIRECTION direction){ 
    lcd.clear();
    lcd.drawRect(0,0,40,9, FILL_TRANSPARENT); //creates the growth bar
    lcd.drawRect(0,8,84,40,FILL_TRANSPARENT); //draws screen border
    lcd.drawRect(0,0,rect_width,9, FILL_BLACK); //fills the growth bar
    
    //check if enemy fish if fully off screen
    if(X == -24){
        X = 85; //reset enemy fish position to 85
        Y = rand() % 36 + 9; //randomly generate new Y position for enemy fish
        E_FISH = rand() % 4 + 1; //randomly select a new enemy fish
    }
    
    fishPos(direction);
    drawFish(lcd);
    enemyFish(lcd);
    Collision();
    Score(lcd);
    Lives();
    
    X--;
    lcd.refresh();
    wait_ms(1000/30);
}
    
//initialies game.            20,     20,        1          
void Game::init(N5110 &lcd, int x, int y, int Fish_size){
    _x = x;
    _y = y;
    X = 85;
    Y = 20;
    FISH_SIZE = Fish_size;
    E_FISH = 1;
    SCORE = 0;
    check_score = 0;
    rect_width = 0;
    barIncrement = 0;
    check_width = 0;
    lives = 3;
    _shift.write(0x4F);
    
    //draw fish 
    drawFish(lcd);
}
    
//draws player fish
void Game::drawFish(N5110 &lcd){
    
    if (FISH_SIZE == 1){
        //draw first fish
        _graphics.Fish_1(lcd, _x, _y);
        FISH_HEIGHT = 4;
        FISH_WIDTH = 9; 
        CENTRE_X = _x + (FISH_WIDTH/2); 
        CENTRE_Y = _y + (FISH_HEIGHT/2);
        
    }else if(FISH_SIZE == 2){
        //draw second fish
        _graphics.Fish_2(lcd, _x, _y);
        FISH_HEIGHT = 6;
        FISH_WIDTH = 14;
        CENTRE_X = _x + (FISH_WIDTH/2); 
        CENTRE_Y = _y + (FISH_HEIGHT/2); 
        
    }else if(FISH_SIZE == 3){
        //draw third fish
        _graphics.Fish_3(lcd, _x, _y);
        FISH_HEIGHT = 8;
        FISH_WIDTH = 17; 
        CENTRE_X = _x + (FISH_WIDTH/2); 
        CENTRE_Y = _y + (FISH_HEIGHT/2);
        
    }else if(FISH_SIZE == 4){
        //draw final fish
        _graphics.Fish_4(lcd, _x, _y);
        FISH_HEIGHT = 12;
        FISH_WIDTH = 23;  
        CENTRE_X = _x + (FISH_WIDTH/2); 
        CENTRE_Y = _y + (FISH_HEIGHT/2);
    }      
}
    
//updates fish position
void Game::fishPos(DIRECTION direction){
    
    //takes the joystick input and alters the value and x & y accordingly
    if(direction.joy == N){
        _y--;
    }else if(direction.joy == S){
        _y++; 
    }else if(direction.joy == E){
        _x++;    
    }else if(direction.joy == W){
        _x--;
    }else if(direction.joy == NE){
        _y--;
        _x++;    
    }else if(direction.joy == NW){
        _y--;
        _x--;    
    }else if(direction.joy == SE){
        _y++;
        _x++;    
    }else if(direction.joy == SW){
        _y++;
        _x--;   
    }else if(direction.joy == CENTRE){
        _x = _x;
        _y = _y;    
    }
    
    //creates the upper x and y boundaries
    x_bound = _x + FISH_WIDTH;
    y_bound = _y + FISH_HEIGHT;
    
    //check play position agains the boundaries of the playing area
    if(_x <= 1){
        _x = 1;
        
    }else if (x_bound >= 82){
        _x = 82 - FISH_WIDTH;  
        
    }else if (_y <= 9){
        _y = 9;    
        
    }else if (y_bound >= 47){
        _y = 47 - FISH_HEIGHT;
    }
}
    
//Keeps score
int Game::Score(N5110 &lcd){
    //print score to screen
    s_length = sprintf(_score,"%2d",SCORE);
    lcd.printString(_score,54,0);
    
    //score limits to grow fish
    if (SCORE < 100){
        FISH_SIZE = 1;                          //smallest fish
        barIncrement = 4; //increments the width of the growth bar by 4 pixels
        
    }else if(SCORE >= 100 && SCORE < 300){
        FISH_SIZE = 2;                          //fish 2
        barIncrement = 2;
        
    }else if (SCORE >= 300 && SCORE <= 700){
        FISH_SIZE = 3;                          //fish 3
        barIncrement = 1;
        
    }else if (SCORE >= 700){
        FISH_SIZE = 4;                          //largest fish
        barIncrement = 0;
    }
    
    //increases the growth bar width each time a the score increases
    if(check_score != SCORE){
        if(FISH_SIZE == 1){
            rect_width = rect_width + 4;
            
        }else if(FISH_SIZE == 2){
            rect_width = rect_width + 2;
            
        }else if(FISH_SIZE == 3){
            rect_width = rect_width + 1;
            
        }else if(FISH_SIZE == 4){
            rect_width = 40;
        }
        
        check_score = SCORE;
    }
    
    //check for change in bar increment if true reset the width of the growth bar   
    if(check_width != barIncrement){
        if(FISH_SIZE == 4){ //if largest fish than growth bar is max
            rect_width = 40;
            
        }else{
            rect_width = 0;
        }
        check_width = barIncrement; //set new check width to new bar increment     
    }
        
    return SCORE;
}
    
//keeps track of lives
int Game::Lives(){
    if (lives == 3){
        _shift.write(0x4F); //write 3
        
    }else if (lives == 2){
        _shift.write(0x5B); //write 2
        
    }else if (lives == 1){
        _shift.write(0x06); //write 1
        
    }else if (lives == 0){
        _shift.write(0x3F); //write 0
    }
    return lives;
}

//checks for collision with other fish
void Game::Collision(){
    centre_xpos = E_CENTRE_X - CENTRE_X;
    centre_ypos = E_CENTRE_Y - CENTRE_Y;
    
    if((centre_xpos == 2 && centre_ypos <= 1) && (centre_xpos == 2 && centre_ypos >= -1)){
        if(FISH_SIZE < E_FISH){
            //remove one life
            lives--;
            
            //flicker busout
            _RGB_led.write(6); //red
            wait_ms(100);
            _RGB_led.write(7); //off  
             
        }else if(FISH_SIZE >= E_FISH){ 
            //increase score by 10
            SCORE = SCORE + 10;
            
            //remove eaten fish
            X = -23;  
            
            //flicker busout
            i = 0;
            while(i < 3){
                colour = rand() % 6 + 1; //generate random colour
                _RGB_led.write(colour);
                wait_ms(100);
                _RGB_led.write(7); //turn off led
                i++;
            }
            _RGB_led.write(7); //turn off led
            i = 0;
        }
    }
}

//generates enemy fish
void Game::enemyFish(N5110 &lcd){
    if (E_FISH == 1){
        //draw first fish
        _graphics.E_Fish_1(lcd, X, Y);
        E_FISH_HEIGHT = 4;
        E_FISH_WIDTH = 9; 
        E_CENTRE_X = X + (E_FISH_WIDTH/2);
        E_CENTRE_Y = Y + (E_FISH_HEIGHT/2);
        
    }else if(E_FISH == 2){
        //draw second fish
        _graphics.E_Fish_2(lcd, X, Y);
        E_FISH_HEIGHT = 6;
        E_FISH_WIDTH = 14; 
        E_CENTRE_X = X + (E_FISH_WIDTH/2);
        E_CENTRE_Y = Y + (E_FISH_HEIGHT/2);
        
    }else if(E_FISH == 3){
        //draw third fish
        _graphics.E_Fish_3(lcd, X, Y);
        E_FISH_HEIGHT = 8;
        E_FISH_WIDTH = 17;
        E_CENTRE_X = X + (E_FISH_WIDTH/2);
        E_CENTRE_Y = Y + (E_FISH_HEIGHT/2); 
        
    }else if(E_FISH == 4){
        //draw final fish
        _graphics.E_Fish_4(lcd, X, Y);
        E_FISH_HEIGHT = 12;
        E_FISH_WIDTH = 23;  
        E_CENTRE_X = X + (E_FISH_WIDTH/2);
        E_CENTRE_Y = Y + (E_FISH_HEIGHT/2);
    }  
}