/* Fish Eat Game v2.0
*   Author: Andrew Knowles
*   Date:   21/04/2021
*   Note: See hearder files for additional recognistion */  

#include "FishEngine.h"

//definitions
#define UP 0
#define DOWN 1
#define CENTRE 2

//objects
Game game;
Settings settings;
Graphics graphics;
HighScore highscore;

// creates intro sequence
void FishEngine::titleSequence(N5110 &lcd){
    lcd.clear();
    graphics.titleScreen(lcd); //prints titlescreen (held in graphics.h)
    lcd.refresh();
    wait_ms(2000);
        
    while(settings.buttonB_state(ButtonB) == 0){
        lcd.clear();
        graphics.confirmationScreen(lcd); //calls confirmation function (held in graphics.h)
        lcd.refresh();
        wait_ms(1000/10);
    }
        
    graphics.screenFlash(lcd); //calls screen flash function (held in graphics.h)
    lcd.refresh();
}

//plays the game
void FishEngine::gamePlay(N5110 &lcd, Joystick &joystick){
    game.init(lcd, 20, 20, 1); //initalise game conditions 
    do{
        DIRECTION direction = {joystick.get_direction()};
        game.gamePlay(lcd, direction);
        playerScore = game.Score(lcd); //updates playerScore in real time  
    }while(game.Lives() != 0);
    
    graphics.gameOver(lcd); //display game over screen
    fileValue = highscore.readFile(); //reads current value stored in file, saves it to fileValue
    
    //if player score is higher that current file value save new highscore
    if(playerScore > fileValue){
        highscore.writeFile(playerScore);
        graphics.newHighscore(lcd, playerScore);   
    }
}

//displays current highscore
void FishEngine::highScore(N5110 &lcd){
    do{
        highscore.displayFile(lcd);   
    }while(settings.buttonB_state(ButtonB) == false);
}

//displays player instructions
void FishEngine::Instructions(N5110 &lcd){
    graphics.playerInstruc(lcd);
}

// creates the games main menu screen with scrolling ability through the use of a state machine.
void FishEngine::mainMenu(N5110 &lcd, Tone &dac, Joystick &joystick){
    const int Fish_1[4][9]= {
        { 1,0,0,1,1,1,1,1,0, },
        { 1,1,1,1,1,1,1,0,1, },
        { 1,1,1,1,1,1,1,1,1, },
        { 1,0,0,1,1,1,1,1,0, },
    };
    
    // outputs for the state machine are used to draw Fish_1 beside the corrosponding 
    // menu choice 
    int g_menu_output[4] = {10, 18, 26, 34};
    state = 0; //set inital state to 0
    direction = CENTRE; //set inital direction to remain on that state until an input is received
    
    while(1){
        lcd.clear();
        lcd.drawRect(0,0,84,48,FILL_TRANSPARENT); //draws screen border
        
        //prints players options
        lcd.printString("New Game", 15, 1);
        lcd.printString("High Score", 15, 2);
        lcd.printString("How to Play", 15, 3);
        lcd.printString("Settings", 15, 4); 
        
        if(joystick.get_direction() == N){ //if the joystick is moved upward, then direction is UP
            direction = UP;
        }else if (joystick.get_direction() == S){//if the joystick is moved downward, then direction is DOWN
            direction = DOWN;
        }else{
            direction = CENTRE; //if the joystick is left in the centre position then direction is CENTRE
        };
        
        y_pos = g_menu_output[state];//y_position is the array output at position 'state'
        
        
        //implement state machine
        switch(state) {
            
            //case for new game
            case 0:
                if(settings.buttonA_state(ButtonA)){
                    graphics.screenFlash(lcd);
                    gamePlay(lcd, joystick);
                }
                switch(direction) {
                    case UP:
                        state = 3;
                        break;
                    case DOWN:
                        state = 1;
                        break;
                    case CENTRE: 
                        state = 0;
                        break;
                }
                break;
                
            //case to view HighScore
            case 1:
                if(settings.buttonA_state(ButtonA)){
                    graphics.screenFlash(lcd);
                    highScore(lcd);
                }
                switch(direction) {
                    case UP:
                        state = 0;
                        break;
                    case DOWN:
                        state = 2;
                        break;
                    case CENTRE: 
                        state = 1;
                        break;
                }
                break;
                
            //case for how to play    
            case 2:
                if(settings.buttonA_state(ButtonA)){
                    graphics.screenFlash(lcd);
                    Instructions(lcd);
                }
                switch(direction) {
                    case UP:
                        state = 1;
                        break;
                    case DOWN:
                        state = 3;
                        break;
                    case CENTRE: 
                        state = 2;
                        break;
                }
                break;
                
            //case for settings    
            case 3:
                if(settings.buttonA_state(ButtonA)){
                    graphics.screenFlash(lcd);
                    settings.settingsMenu(lcd, dac, joystick);    
                }
                switch(direction) {
                    case UP:
                        state = 2;
                        break;
                    case DOWN:
                        state = 0;
                        break;
                    case CENTRE: 
                        state = 3;
                        break;
                    
                }
                break;
            default:
                state = 0;
                break;
        }
        
        //draw sprite at position (3, y_pos)
        lcd.drawSprite(3, y_pos, 4, 9, (int*)Fish_1);
        lcd.refresh();
        wait_ms(500);
    }
}