#include "mbed.h"

DigitalIn button_A(p29);
DigitalIn button_B(p28);
DigitalIn button_C(p27);
DigitalIn button_D(p26);

DigitalOut red_led(p24);
DigitalOut green_led(p23);
DigitalOut blue_led(p22);

void init_buttons();
void init_leds();

int main()
{
    init_buttons();  // turn off internal pull-up/pull-down resistors
    init_leds();     // tursn off the LEDs

    while(1) {

        // check if button A pressed
        if ( button_A.read() == 1) {
            // writing a 1 turns the LED off, 0 makes it turn on (active-low)
            red_led.write(0);  // if it is, turn the red LED on
        } else if (button_B.read() == 1) { // check if B pressed
            green_led.write(0);  // if it is, turn the green LED on
        } else if ( button_C.read() == 1) { // check if C pressed
            blue_led.write(0);  // if it is, turn the blue LED on
        } else {
            // if no buttons pressed, ensure all the LEDs are off
            red_led.write(1);
            green_led.write(1);
            blue_led.write(1);
        }

        wait(0.1);  // small delay

    }
}

void init_buttons()
{
    // PCB has external pull-down resistors so turn the internal ones off
    // (default for DigitalIn)
    button_A.mode(PullNone);
    button_B.mode(PullNone);
    button_C.mode(PullNone);
    button_D.mode(PullNone);
}

void init_leds()
{
    // LEDs are common anode (active-low) so writing a 1 will turn them off
    red_led.write(1);
    green_led.write(1);
    blue_led.write(1);

    // this syntax is equivalent
    //red_led = 1;
    //green_led = 1;
    //blue_led = 1;
}

