#ifndef SKULL_H
#define SKULL_H
#include "Entity.h"
#define DASH_DELAY 120

/**Skull Class
*@author Steven Mahasin
*@brief Creates a Skull which inherits the Entity class, this is currently the only boss in the game.
*@date May 2019
*/
class Skull : public Entity {
private:
    // Member Variables
    /**
    *   @brief the shadow of Skull has a separate size and offset, so it has to have such member variable
    */
    SpriteSize _shadow;
    /**
    *   @brief a status of wether the skull is dashing
    */
    bool _dash;
    /**
    *   @brief a counter to let the skull dash periodically
    */
    int _dash_counter;
    /**
    *   @brief an index to choose which velocity the Skull currently has when dashing
    */
    int _velocity_index;
    
    // Member Functions
    /**
    *   @brief increase _frame.count which increases _frame.number to animate skull
    */
    void increment_frames();
    /**
    *   @brief updates the offset of the skull so that it floats up and down periodically above the shadow (purely graphical)
    */
    void update_offsets();
    /**
    *   @brief moves the skull towards the player, similar to headless
    *   @param player_x @details player x-position
    *   @param player_y @details player y-position
    */
    void approaching_movement(float player_x, float player_y);
    /**
    *   @brief moves the skull in a dashing manner
    */
    void dash_movement();
    
public:
    // Constructor
    Skull(float pos_x, float pos_y);

    // Functions
    /**
    *   @brief calls the function and conditions to move (both dashing and approaching)
    *   @param x_value @details player x-position
    *   @param y_value @details player y-position
    *   @param map @details the 2d map array that dictates where there are walls or empty space
    *   @param doorways @details an array that dictates which side of the wall has a doorway
    */
    virtual void move(float x_value, float y_value, char * map, bool * doorways); // movement control and miscellaneous updates
    /**
    *   @brief reduce _hp by damage
    *   @param damage @details the amount of damage to be taken
    */
    virtual void take_damage(int);
    /**
    *   @brief a function of drawing the skull onto the screen
    *   @param lcd @details the screen where the skull is drawn on
    */
    virtual void draw(N5110 &lcd);
};

const float skull_velocity_pattern[7] = {0, 0, 0, 0.8, 1.6, 2};

const char skull_sprite[4][2][23][21] = //skull_sprite[Face][mouthclose/mouthopen][Size_Y][Size_X]
{
    {   // Up
        {
            {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
            {0,0,0,0,0,1,1,2,2,2,2,2,2,2,1,1,0,0,0,0,0},
            {0,0,0,1,1,2,1,2,2,2,2,2,2,2,2,2,1,1,0,0,0},
            {0,0,1,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,1,0,0},
            {0,1,2,2,2,2,2,1,1,1,2,2,2,2,2,2,2,2,2,1,0},
            {0,1,2,2,2,2,2,2,1,2,1,2,2,2,2,2,2,2,2,1,0},
            {0,1,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,1,0},
            {1,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,1},
            {1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1},
            {1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1},
            {1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1},
            {1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1},
            {1,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,1},
            {0,1,2,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,2,1,0},
            {0,1,2,2,1,1,1,1,2,2,2,2,2,1,1,1,1,2,2,1,0},
            {0,0,1,2,1,1,1,1,1,2,2,2,1,1,1,1,1,2,1,0,0},
            {0,0,1,2,2,1,1,1,2,2,2,2,2,1,1,1,2,2,1,0,0},
            {0,0,0,1,2,2,1,1,1,2,2,2,1,1,1,2,2,1,0,0,0},
            {0,0,0,0,1,2,2,1,1,1,1,1,1,1,2,2,1,0,0,0,0},
            {0,0,0,0,0,1,1,2,2,2,2,2,2,2,1,1,0,0,0,0,0},
            {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        },
        {
            {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
            {0,0,0,0,0,1,1,2,2,2,2,2,2,2,1,1,0,0,0,0,0},
            {0,0,0,1,1,2,1,2,2,2,2,2,2,2,2,2,1,1,0,0,0},
            {0,0,1,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,1,0,0},
            {0,1,2,2,2,2,2,1,1,1,2,2,2,2,2,2,2,2,2,1,0},
            {0,1,2,2,2,2,2,2,1,2,1,2,2,2,2,2,2,2,2,1,0},
            {0,1,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,1,0},
            {1,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,1},
            {1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1},
            {1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1},
            {1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1},
            {1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1},
            {1,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,1},
            {0,1,2,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,2,1,0},
            {0,1,2,2,1,1,1,1,2,2,2,2,2,1,1,1,1,2,2,1,0},
            {0,0,1,2,1,1,1,1,1,2,2,2,1,1,1,1,1,2,1,0,0},
            {0,0,1,2,1,1,1,1,2,2,2,2,2,1,1,1,1,2,1,0,0},
            {0,0,1,2,2,1,1,1,1,2,2,2,1,1,1,1,2,2,1,0,0},
            {0,0,0,1,2,2,1,1,1,1,1,1,1,1,1,2,2,1,0,0,0},
            {0,0,0,0,1,2,1,1,1,1,1,1,1,1,1,2,1,0,0,0,0},
            {0,0,0,0,0,1,2,2,1,1,1,1,1,2,2,1,0,0,0,0,0},
            {0,0,0,0,0,0,1,1,2,2,2,2,2,1,1,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0},
        }
    },
    {   // Right
        {
            {0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0},
            {0,0,0,0,1,1,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0},
            {0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0},
            {0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0},
            {0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0},
            {1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0},
            {1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0},
            {1,2,2,2,2,1,2,2,2,2,2,2,1,1,1,2,1,2,2,1,0},
            {1,2,2,2,2,2,1,2,2,2,2,1,1,1,1,1,1,2,2,1,0},
            {1,2,2,2,2,1,1,1,2,2,2,1,1,1,2,2,1,1,2,1,0},
            {1,2,2,2,1,1,1,1,2,2,2,2,1,1,2,2,1,1,2,1,0},
            {0,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,1,0},
            {0,0,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0},
            {0,0,0,0,0,1,2,2,2,2,1,2,2,2,2,2,2,1,1,0,0},
            {0,0,0,0,0,0,1,2,2,2,1,1,2,1,2,2,2,1,1,0,0},
            {0,0,0,0,0,0,1,2,2,2,2,1,1,1,1,1,2,2,1,0,0},
            {0,0,0,0,0,0,1,1,2,2,2,2,2,1,2,1,1,1,1,0,0},
            {0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,1,2,1,0,0,0},
            {0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,1,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1,1,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        },
        {
            {0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0},
            {0,0,0,0,1,1,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0},
            {0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0},
            {0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0},
            {0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0},
            {1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0},
            {1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0},
            {1,2,2,2,2,1,2,2,2,2,2,2,1,1,1,2,1,2,2,1,0},
            {1,2,2,2,2,2,1,2,2,2,2,1,1,1,1,1,1,2,2,1,0},
            {1,2,2,2,2,1,1,1,2,2,2,1,1,1,1,2,1,1,2,1,0},
            {1,2,2,2,1,1,1,1,2,2,2,2,1,1,1,1,1,1,2,1,0},
            {0,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,1,0},
            {0,0,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,0},
            {0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0},
            {0,0,0,0,0,0,1,2,2,1,1,1,2,2,2,2,2,1,1,0,0},
            {0,0,0,0,0,0,1,2,2,2,1,1,1,2,1,2,2,2,1,0,0},
            {0,0,0,0,0,0,1,2,2,2,2,1,0,1,2,1,1,2,1,0,0},
            {0,0,0,0,0,0,1,2,2,2,2,1,0,1,0,0,0,1,0,0,0},
            {0,0,0,0,0,0,0,1,2,2,2,2,1,2,1,1,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,1,1,2,2,2,2,1,2,1,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,1,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,1,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0},
        }
    },
    {   // Down
        {
            {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
            {0,0,0,0,0,1,1,2,2,2,2,1,1,2,1,1,0,0,0,0,0},
            {0,0,0,1,1,2,2,2,2,2,2,2,1,1,2,2,1,1,0,0,0},
            {0,0,1,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,1,0,0},
            {0,1,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,1,0},
            {0,1,2,2,2,2,2,1,2,2,2,2,2,1,2,2,2,2,2,1,0},
            {0,1,2,2,1,1,1,1,2,2,2,2,2,1,1,1,1,2,2,1,0},
            {1,2,2,1,1,1,2,1,2,2,2,2,2,1,2,1,1,1,2,2,1},
            {1,2,2,1,1,2,2,2,1,2,2,2,1,2,2,2,1,1,2,2,1},
            {1,2,2,1,1,2,2,1,2,2,2,2,2,1,2,2,1,1,2,2,1},
            {1,2,2,2,1,1,1,2,2,2,1,2,2,2,1,1,1,2,2,2,1},
            {1,2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,2,2,2,2,1},
            {1,2,1,2,2,2,2,2,2,1,2,1,2,2,2,2,2,2,1,2,1},
            {0,1,2,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,2,1,0},
            {0,1,2,2,1,1,1,2,1,2,1,2,1,2,1,1,1,2,2,1,0},
            {0,0,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,0,0},
            {0,0,1,2,2,1,1,2,1,2,1,2,1,2,1,1,2,2,1,0,0},
            {0,0,0,1,2,2,1,2,2,2,2,2,2,2,1,2,2,1,0,0,0},
            {0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0},
            {0,0,0,0,0,1,1,2,2,2,2,2,2,2,1,1,0,0,0,0,0},
            {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        },
        {
            {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
            {0,0,0,0,0,1,1,2,2,2,2,1,1,2,1,1,0,0,0,0,0},
            {0,0,0,1,1,2,2,2,2,2,2,2,1,1,2,2,1,1,0,0,0},
            {0,0,1,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,1,0,0},
            {0,1,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,1,0},
            {0,1,2,2,2,2,2,1,2,2,2,2,2,1,2,2,2,2,2,1,0},
            {0,1,2,2,1,1,1,1,2,2,2,2,2,1,1,1,1,2,2,1,0},
            {1,2,2,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,2,2,1},
            {1,2,2,1,1,1,2,1,1,2,2,2,1,1,2,1,1,1,2,2,1},
            {1,2,2,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,2,2,1},
            {1,2,2,2,1,1,1,2,2,2,1,2,2,2,1,1,1,2,2,2,1},
            {1,2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,2,2,2,2,1},
            {1,2,1,2,2,2,2,2,2,1,2,1,2,2,2,2,2,2,1,2,1},
            {0,1,2,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,2,1,0},
            {0,1,2,2,1,1,1,2,2,2,2,2,2,2,1,1,1,2,2,1,0},
            {0,0,1,2,1,1,1,2,1,2,1,2,1,2,1,1,1,2,1,0,0},
            {0,0,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,0,0},
            {0,0,1,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,1,0,0},
            {0,0,0,1,2,2,1,1,1,1,1,1,1,1,1,2,2,1,0,0,0},
            {0,0,0,0,1,2,1,2,1,2,1,2,1,2,1,2,1,0,0,0,0},
            {0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0},
            {0,0,0,0,0,0,1,1,2,2,2,2,2,1,1,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0},
        }
    },
    {   // Left
        {
            {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
            {0,0,0,0,0,1,1,2,2,2,2,2,2,2,1,1,0,0,0,0,0},
            {0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0},
            {0,0,1,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0},
            {0,1,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,1,0,0},
            {0,1,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0},
            {0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0},
            {1,2,2,1,2,1,1,1,2,2,2,2,2,2,1,2,2,2,2,1,0},
            {1,2,2,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,2,1,0},
            {1,2,1,1,2,2,1,1,1,2,2,2,1,1,1,2,2,2,2,1,0},
            {1,2,1,1,2,2,1,1,2,2,2,2,1,1,1,1,2,2,2,1,0},
            {1,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,0,0},
            {0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,0,0,0},
            {0,1,1,2,2,2,2,2,2,1,2,2,2,2,1,0,0,0,0,0,0},
            {0,1,1,2,2,2,1,2,1,1,2,2,2,1,0,0,0,0,0,0,0},
            {0,1,2,2,1,1,1,1,1,2,2,2,2,1,0,0,0,0,0,0,0},
            {0,1,1,1,1,2,1,2,2,2,2,2,1,1,0,0,0,0,0,0,0},
            {0,0,1,2,1,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0},
            {0,0,1,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0},
            {0,0,1,1,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        },
        {
            {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
            {0,0,0,0,0,1,1,2,2,2,2,2,2,2,1,1,0,0,0,0,0},
            {0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0},
            {0,0,1,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0},
            {0,1,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,1,0,0},
            {0,1,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0},
            {0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0},
            {1,2,2,1,2,1,1,1,2,2,2,2,2,2,1,2,2,2,2,1,0},
            {1,2,2,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,2,1,0},
            {1,2,1,1,2,1,1,1,1,2,2,2,1,1,1,2,2,2,2,1,0},
            {1,2,1,1,1,1,1,1,2,2,2,2,1,1,1,1,2,2,2,1,0},
            {1,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,0,0},
            {0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,0,0,0},
            {0,1,1,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0},
            {0,1,1,2,2,2,2,2,1,1,1,2,2,1,0,0,0,0,0,0,0},
            {0,1,2,2,2,1,2,1,1,1,2,2,2,1,0,0,0,0,0,0,0},
            {0,1,2,1,1,0,1,0,1,2,2,2,2,1,0,0,0,0,0,0,0},
            {0,0,1,0,0,0,1,0,1,2,2,2,2,1,0,0,0,0,0,0,0},
            {0,0,0,0,1,1,2,1,2,2,2,2,1,0,0,0,0,0,0,0,0},
            {0,0,0,1,2,1,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0},
            {0,0,1,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,1,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        }
    },
    
};

const char skull_shadow_sprite[2][5][19] = 
{
    {
        {0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0},
        {0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
        {0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0}
    },
    {
        {0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0},
        {0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
        {0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
        {0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
        {0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0}
    }
};

#endif