
#ifndef SNAKE_H
#define SNAKE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "GameEngine.h"


class Snake
{


public:
    Snake();
    ~Snake();

    enum Directions {
        up,
        down,
        left,
        right,
        null
    };

    void init();
    int set_direction(Gamepad &pad);
    //Directions get_direction();
    void move_and_draw_snake(Gamepad &pad, N5110 &lcd);
    void gameover_true(N5110 &lcd);
    void check_if_scored(N5110 &lcd, Gamepad &pad);
    void check_wall_collisions();
    //  void render(N5110 &lcd);
    void clear_applepos(N5110 &lcd);




private:

    bool _gameover;
    Directions _direction;
    int _length;
    int _score;
    GameEngine _engine;


};


#endif