/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name: Owen Cavender
Username: el17oc
Student ID Number: 201159294
Date: 20/04/2020

The game loop will be entered after the game is initialised. The first step is to process the
user input (if any). The next step is to update the game engine depending on the input i.e.
moving a character or checking for collisions. The final step is to update the display and render
this on the LCD. There is usual////
*/

// includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "snake.h"
#include "GameEngine.h"

//objects
Gamepad pad;
Snake snake;
N5110 lcd;
GameEngine engine;
//functions

void welcome();
void render();
void init();
void update_game_state();

int main()  
{

    int fps = 6;  // frames per second

    init();                   // initialise and then display welcome screen...
    welcome();
    wait(1.0f/fps);  // and wait for one frame period
    render();
                                                         //ROB atm the code works to here 
                                                         //need to draw an initial snake    
    while (1) {
        snake.set_direction(pad);
        update_game_state();
        wait(1.0f/fps);                                 
    }

}



void init()
{

    snake.init();           //need to initialise snake class
    pad.init();
    lcd.init();
    engine.init(48, 24, 48, 30, 48, 47);    // need to choose initial values A$AP   shx shy apx apy Oshx, Oshy
}

void update_game_state()   //FUNCTION 2
{

    snake.set_direction(pad);
    snake.move_and_draw_snake(pad, lcd);
    snake.gameover_true(lcd);
    snake.check_if_scored(lcd, pad);

}

void welcome()
{

    lcd.printString("     SNAKE    ",0,1);
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();

    // wait flashing LEDs until start button is pressed
    while ( pad.start_pressed() == false) {
        lcd.setContrast( pad.read_pot1());
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }

}


void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();
    lcd.drawRect(0, 0, 84, 42, FILL_TRANSPARENT);
    Vector2D originalhead = engine.get_Snakehead();                                                     //draw constant rectangle around frame of lcd indicating walls
    Vector2D originalbody =  engine.get_oldSnakehead();
    
    lcd.setPixel(originalhead.x, originalhead.y,1);
    lcd.setPixel(originalbody.x, originalbody.y,1);
    
}


// for (int z=0; z<=_length; z++) {
//     lcd.setPixel(snakebody[z].x, snakebody[z].y, 1);
// }
//use to draw wall - do i need to draw it everytime or can i do it as  constant
//}






//has an apple been collected? if so increase length by 1 increase score by 1 and makes coin collecting noise and spawn new apple
//has snake touched itself or wall - if so end game - present score - make xxx sound fail --- apple needs to be different to the snakes body and different to wall
//has button button been pressed - if so change direction accordingly
//max length - when length = width x height - 1 - game complete
//each pixel of length must follow the front pixel
// 2 modes - time race - "get an apple before time runs out" - resets timer --- then classic snake



//need to add audio, leds, (main menu end menu and entering and leaving the while(1) loop), time trial mode, .h files