#ifndef ITEM_H
#define ITEM_H

#include "mbed.h"
/** item Class
* @1 generate an item in random position after one disappear
* @2 build the item's structer
* @3 build a barrier to increase difficulty
* @date April 13th 2020
* @author Yaomochu


@code

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "item.h"
#include <cstdlib> //the standard library by which we need the rand() and srand() function
#include <ctime> //in order to generate random number we need <ctime>

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad gamepad;
item _item;

//the position of the player is essential
//the player's position at first can not be same with the item, so I init the player's position and the item's position together
int _player_x;
int _player_y;
int _player_score;
bool _collision_flag;// to see if the player can get a score

int main() {
  _item.init();// use this to generate the item
  srand(time(NULL));// generate random values
  _player_score = 0;// set player score to 0;
  _player_x = 40;
  _player_y = 10;//make sure they are not in the same position at first,but player on the underlevel
  while(1) {
    
    // becasue the module of the player is big so it has to be make sure that 
    //the item will be collected when the edge of the module collide with the item
    if ((_player_x == _item.get_item_x()
      && (_player_y == _item.get_item_y() - 8)) {  
    _collision_flag = true;
    _player_score++;
    _item.set_item(((rand()%80)+ 5) , ((rand()%80)+ 5));  // use the rand()%m function to generate a number from 80 to 1
    // on a constrained random position.
    gamepad.tone(1000, 0.1);//cause a noise to makesure the coin has collected   
    }
    
    // Print the item.
    lcd.drawSprite(_item.get_item_x(),_item.get_item_y(),5,6,(int*)_item.get_item_form());
  }
}

* @ endcode
*/

class item
{
public:
    // Constructor and Destructor.
    item();
    ~item();

    // Initialises object.*/
    void init();
    //Sets the item coordinates.
    //rand_x = a random number that determines the x coordinate
    //rand_y = a random number that determines if the item's generated level
    void set_item(int random_x, int random_y);
    int *get_item_form();//
    int get_item_x();
    int get_item_y();


private:
    int _x;//the x coordinate of the item
    int _y;//the y coordinate of the item
};
#endif