#ifndef LINE_H
#define LINE_H

#include "mbed.h"

struct Line {
 int length;
 int left;
 int right;
 int y;
 };
 //the line structer will have four main elements 
 
/** surface Class
* @1 the leftside of the line move toward right then the rightside should also move to the right to keep the length
* @2 the line will be random length but must be suitable
* @3 makesure there are two surface for player to stay
* @date April 22th 2020
* @author Yaomochu

@code

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "surface.h"
#include <cstdlib>
#include <ctime>

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad gamepad;
Surface _surface;

Line line_1_value;
Line line_2_value;
Line line_3_value;
Line line_4_value;
Line line_5_value;
Line line_6_value;

int main() {
    _surface.init(20,40);
    while(1) {
    //draw line 1
    _surface.line_1();
    line_1_value = _surface.getline_1();
    lcd.drawLine(line_1_value.left,line_1_value.y,line_1_value.right,line_1_value.y,FILL_BLACK);
    //draw line 2
    _surface.line_2();
    line_2_value = _surface.getline_2();
    lcd.drawLine(line_2_value.left,line_2_value.y,line_2_value.right,line_2_value.y,FILL_BLACK);
    //draw line 3
    _surface.line_3();
    line_3_value = _surface.getline_3();
    lcd.drawLine(line_3_value.left,line_3_value.y,line_3_value.right,line_3_value.y,FILL_BLACK);
    //draw line 4
    _surface.line_4();
    line_4_value = _surface.getline_4();
    lcd.drawLine(line_4_value.left,line_4_value.y,line_4_value.right,line_4_value.y,FILL_BLACK);
    //draw line 5
    _surface.line_5();
    line_3_value = _surface.getline_5();
    lcd.drawLine(line_5_value.left,line_5_value.y,line_5_value.right,line_5_value.y,FILL_BLACK);
    //draw line 6
    _surface.line_6();
    line_6_value = _surface.getline_6();
    lcd.drawLine(line_6_value.left,line_6_value.y,line_6_value.right,line_6_value.y,FILL_BLACK);
    }
}

@endcode
*/

//the surface function is to creat the surface for player to stand on and move
class Surface
{
public:
Surface();
~Surface();
void init(int y1, int y2);
//init the line at first to set the initial position
void line_1();
void line_2();
void line_3();
void line_4();
void line_5();
void line_6();
Line getline_1();
Line getline_2();
Line getline_3();
Line getline_4();
Line getline_5();
Line getline_6();

private:
Line _line_1;
Line _line_2;
Line _line_3;
Line _line_4;
Line _line_5;
Line _line_6;

};
#endif

